\name{filtpoly2DC}
\Rdversion{1.1}
\alias{filtpoly2DC}
\title{create a 2D filter
}
\description{Interactive creation of 2D filter
}
\usage{
filtpoly2DC(fftA2, col=rainbow(100), FL , scale=0)
}
\arguments{
  \item{fftA2}{Fourier transform a previously defined filter
  }
  \item{col}{color palette for the plot}
  \item{FL}{previously set polygon, if blank user
  defines FL by clicking}
 \item{scale}{scale option for plot}

  
}
\details{clicks are done only on one side of the FT
  and they are then symmetrically reflected
}
\value{list
  \item{FL}{polygon filter}
  \item{kx1}{wavenumber in the x-direction}
  \item{ky1}{wavenumber in the y-direction}
  \item{d}{dimensions of the matrix}
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\examples{


\dontrun{

gr = grey(0:100/100)

tee = 0:127

A = matrix(ncol=128, nrow=128)

zx = row(A)-1
zy = col(A)-1

freq = 16

A =  20*cos(2*pi*zy/freq )

phix=0
phiy=20


Arot =  10*(cos(2*pi*(zy+phiy)/freq + 2*pi*(zx+phix)/freq ) )

AB = A + Arot
par(mfrow=c(2,2))

image(A, col=gr, asp=1); title("first signal")
image(Arot, col=gr, asp=1); title("second signal")
image(AB, col=gr, asp=1); title("Combined signal")

par(mfrow=c(2,1))

AFL = filtdesign2DC(AB, scale=0)



}



}
\keyword{misc}
