\name{pass2DFILT}
\alias{pass2DFILT}
\title{PassBand 2D Filter image.
}
\description{
Using a polygon determined in the 2D
transform domain, return a filterred image
with wavenumbers within the polygon eliminated, or without.
}
\usage{
pass2DFILT(fftA2, kx1, ky1, FL, IO = 1)
}
\arguments{
  \item{fftA2}{
}
  \item{kx1}{wavenumber in X
}
  \item{ky1}{wavenumber in Y
}
  \item{FL}{polygon mask for filtering
}
  \item{IO}{In-Out flag: 1, remove values in polygon, 2 = remove values out of polygon.
}
}
\details{
Polygon can be anything in the wavenumber domain -
but it should match the kx1, ky1 ranges.
The polygon is determined in the FT domain.


}
\value{Filtered image, same shape as input image.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{quick2Dfilt
}
\examples{

########  load up image stored in KFR data
data(gmand1)
### extract the image from the class S4 pixmap
h = attr(gmand1, 'grey')
######   rotate the pixmap, so it is in correct image format
mzup = t(h[nrow(h):1, ])

####   or load from a file: load('./mandrake_GRAY.RDATA', verbose=TRUE)

d2 = dim(mzup)

        Fmand = ddfft(mzup)

        FAB = fft(mzup)

        PARMS = getKXKY(FAB)
        nyqpt = 0.5
	cutpt = 0.4
        AFL2 =list(d=d2, kx1=PARMS$kx, ky1=PARMS$ky)

        ########  polygon for filtering
        AFL2$FL =
            list(
                x = c(  -cutpt,  -nyqpt  , -nyqpt, -cutpt,
                    cutpt,  nyqpt, nyqpt , cutpt ),
                y = c(  -nyqpt,  -cutpt  ,  cutpt,  nyqpt,
                    nyqpt , cutpt , -cutpt,      -nyqpt )
            )


#####  first plot the filter reject/pass zones
	    plot(c(-nyqpt, nyqpt), c(-nyqpt, nyqpt), type='n', asp=1 , axes=FALSE, xlab='kx', ylab='ky' )
	    rect(-nyqpt, -nyqpt , nyqpt, nyqpt)
	    polygon(AFL2$FL, col=rgb(.85, .85, 1), border='black')
	    axis(1)
	    axis(2)
	    abline(v=0, h=0, lty=2)
	    title('Shaded region is reject or pass band')


            
        ###    Low Pass Filter (delete high frequencies)
        Fsmo = pass2DFILT(FAB  , PARMS$kx, PARMS$ky, AFL2$FL, IO=1)
    

### 	image(Mod(Fsmo), col=grey((0:99)/100), asp=1 )
        




}
\keyword{misc}
