\name{quick2Dfilt}
\alias{quick2Dfilt}
\title{Quick 2D Filter
}
\description{
Simple 2D filter to show lowpass and hipass
versions of an image.
}
\usage{
quick2Dfilt(mzup, cutpt = 0.45, gr = grey(0:100/100))
}
\arguments{
  \item{mzup}{2D image, grey
}
  \item{cutpt}{cutoff frequency, range c(0, 0.5)
}
  \item{gr}{grey scale for plotting
}
}
\details{
the image is assumed to have a sample interval of 1 in both x, y directions.
}
\value{Side effects - plotting of original image, and filtered image.
return list with both low-pass and high-passimages.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{pass2DFILT

}
\examples{

########  load up image stored in KFR data
data(gmand1)
### extract the image from the class S4 pixmap
h = attr(gmand1, 'grey')
######   rotate the pixmap, so it is in correct image format
mzup = t(h[nrow(h):1, ])
#####  apply and plot filters
quick2Dfilt(mzup, cutpt = 0.3)


}
\keyword{misc}
