\name{show2dfft}
\Rdversion{1.1}
\alias{show2dfft}
\title{Show 2D-FT 
}
\description{
  Plot 2D FT of an image
}
\usage{
show2dfft(fftA2, dx = 1, dy = 1, scale = 1, col = rainbow(100), xlim = NULL, ylim = NULL)
}
\arguments{
  \item{fftA2}{Fourier Transform of a 2D image
}
  \item{dx}{sampling interval in X
}
  \item{dy}{ sampling interval in Y
}
  \item{scale}{0,1,2,3 = scaling flag
}
  \item{col}{ color palette
}
  \item{xlim}{ limit in the X direction
}
  \item{ylim}{ limit in the Y direction
}
}

\value{Graphical  side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{fft
}
\examples{

gr = grey(0:100/100)

tee = 0:127

A = matrix(ncol=128, nrow=128)

zx = row(A)-1
zy = col(A)-1

freq = 16


par(mfrow=c(2,2))

A =  10*cos(2*pi*zy/freq )
image(A, col=gr, asp=1)


B =  10*cos(2*pi*zx/(freq/2) )
image(B, col=gr, asp=1)


B2d = ddfft(B)
A2d = ddfft(A)
sfs =  show2dfft(B2d, col=topo.colors(100)  )
sfs =  show2dfft(A2d, col=topo.colors(100) )



}
\keyword{misc}
