DECIM <-
function(TH, sel=1:length(TH), fh=10, dec=5)
  {
    if(missing(sel)) { sel = 1:length(TH) }
    if(missing(fh)) { fh=NA }
    if(missing(dec)) { dec=5 }
    
    for(i in 1:length(sel))
      {
        ii = sel[i]

        xamp = TH[[ii]]$amp
        mn = mean(xamp, na.rm=TRUE)
        nacop = is.na(xamp)
        xamp[nacop] = mn
        
        dt = TH[[ii]]$dt

        if(!is.na(fh))
          {
            ynew = RSEIS::butfilt(xamp, fl=0, fh=fh, deltat=dt, type="LP", proto="BU", npoles=5, chebstop=30.0, trbndw=0.3 )
            ynew[nacop] = NA
          }
        else
          {
            ynew = TH[[ii]]$amp

          }
        
        
        TH[[ii]]$amp = ynew[seq(from=1, to=length(ynew), by=dec)]
        
        TH[[ii]]$dt = TH[[ii]]$dt*dec
        TH[[ii]]$N = length(TH[[ii]]$amp)
        
      }
    return(TH)
  }

