DISPERSION<-function(y, dt, fl, fh, PLOT=FALSE)
  {
    if(missing(PLOT)) PLOT=FALSE

    ###   y = time series (with no NA samples)
    ###   dt = delta-T
    ###   fl = low frequencies cut off 
    ###   fh = high frequencies cut off
    ###    PLOT = logical
    
  ##  Calculate the arrival of narrow band signals on a seismic wave trace
    
    TAPER = 0.05
    POSTTAPER = 0.05

    if(PLOT)  x = seq(from=0, length=length(y), by= dt)

   
    tapy = RSEIS::applytaper(y, p = TAPER)
    ty = tapy

    NF = length(fl)

    sampMAXES = rep(NA, length=NF)
    
    for(i in 1:NF )
      {
        fy = RSEIS::butfilt(ty, fl[i], fh[i], dt, "BP", "BU")
        ftapy = RSEIS::applytaper(fy, p = POSTTAPER)
        fy = ftapy
        
        ev = RSEIS::envelope(fy)
        
        wm = which.max(ev)
        

        sampMAXES[i] = wm

        if(PLOT)
          {
            plot(x,fy, type='l')
            lines(x, ev, col='red')
            abline(v=x[wm])
          }
        
      }
    return(sampMAXES)
  }



