GET.TTCURVES <-
function(Z=35, DIS=seq(from=5, to=180, by=5), IASPHOME="")
  {
    if(missing(DIS)) {  DIS  = seq(from=5, to=180, by=5)  }
    if(missing(Z)) { Z=35 }



 if(missing(IASPHOME)) {
   IASPHOME = SetIASPhome()
  #  IASPpath = SetIASPhome()
 }


  if(!file.exists('iasp91.hed'))
    {
      cmd1 = paste(sep="", "ln -s ", IASPHOME, "/iasp91.hed")
      system(cmd1)

    }

  if(!file.exists('iasp91.tbl'))
    {
      cmd2 = paste(sep="", "ln -s ", IASPHOME, "/iasp91.tbl")
      system(cmd2)
    }

    LD = list()

    PHASE = NULL

    for(i in 1:length(DIS) )
      {

        dis = DIS[i]
        
        cmdd = paste(sep = " ", "ttBK ", Z, dis, "> ttBK.tempoutput")
        B = system(cmdd)
        A = scan(file = "ttBK.tempoutput", list(num = 0, phase = "",
                   sec = 0, tmin = 0, tsec = 0, dtdd = 0, dtdh = 0,
                   dddp = 0), skip = 1, quiet = TRUE)

        ##########  this fix is set to conform with IASPEI STANDARD SEISMIC PHASE LIST
        ##########   see data(phasedoc)


        
        A$phase=sub("diff", "dif", A$phase)

        LD[[i]] = list(dis=dis, phase=A$phase, time=A$sec)

        
      }


    PHASE = NULL

    for(i in 1:length(DIS) )
      {
        PHASE = unique( c( PHASE, LD[[i]]$phase))
      }

    TTCURVES = list()
    ttphases = vector()
    
    for(i in 1:length(PHASE))
      {

        
        d = vector()
        t = vector()
        k = 0
        for(j in 1:length(DIS) )
          {
            p = LD[[j]]$phase
            ##  cbind(LD[[j]]$phase, LD[[j]]$time)

            
            if(any(p==PHASE[i]))
              {
                
                k = k +1
                wk = which(p==PHASE[i])
                
                ##  if(length(wk)>1)
                ##    {
                ##      print(paste(i,j, p))
                ##    }
                d = c(d, rep(LD[[j]]$dis, times=length(LD[[j]]$time[wk])) )
                t = c(t, LD[[j]]$time[wk])
              }
            
          }

        ttphases[i] = PHASE[i]

        ## d = d[1:(length(d)-1)]
      ##   t = t[1:(length(d)-1)]

        tord = order(t)
        
        t = t[tord]
        d = d[tord]

        
        TTCURVES[[i]] = list(phase=PHASE[i], dis=d, sec=t)    



      }

    attr(TTCURVES, 'phases')<-ttphases

    return(TTCURVES)

  }

