SurfaceWaves<-function(V = seq(from=2, to=5, length=10) , Ddeg = seq(from=0, to=180, by=2) , TIntercept=0 , col=rgb(1, .6,.6)    , add=TRUE)
  {
    if(missing(add)) add=TRUE
    if(missing(V))   V = seq(from=2, to=5, length=10)
    if(missing(Ddeg))   Ddeg = seq(from=0, to=180, by=2)
    if(missing(TIntercept)) TIntercept=0
    if(missing(col)) col=rgb(1, .6,.6) 
    
    u = par("usr")
    
    duang = u[2]-u[1]
    dutim = u[4]-u[3]

    deltaang = duang*0.01
    deltatim = dutim*0.01

    NV = length(V)

    if(length(col)<NV ) col = rep(col, times=NV) 
  
    for(i in 1:NV )
      {
        
        D = 6371*Ddeg*pi/180

        Vlove = V[i]
        ## Vrayl = 0.9*Vlove

        Tlove = TIntercept + D/Vlove
       ## Trayl = TIntercept + D/Vrayl

        if(add)
          {
            
            dright = (u[2]-deltaang)
            tright =(6371*(dright)*pi/180) /Vlove
            
            ttop = u[4]-deltaang
            dtop = (Vlove*(ttop))*180/(pi*6371)

            if(InRect(dright, tright, u[1], u[3], u[2], u[4]))
              {
                lab = formatC(Vlove, format="f", digits=2)
                RPMG::textrect(dright, tright, lab)
              }
            if(InRect(dtop, ttop, u[1], u[3], u[2], u[4]))
              {
                lab = formatC(Vlove, format="f", digits=2)
                RPMG::textrect(dtop, ttop, lab)
              }

            lines(Ddeg, Tlove, lty=2, col=col[i] )
            ## lines(Ddeg, Trayl, lty=2, col=rgb(.6, .6, 1) )
          }

      }

    invisible(list(Ddeg=Ddeg, Tlove=Tlove))

  }

