TELray<-function(MYPHS, mfrow=c(4,4) , PS=FALSE )
  {
    if(missing(PS)) PS = FALSE
    if(missing(mfrow)) mfrow=c(4,4)

    if(PS) jpostscript("TELESRAY", P=c(14, 14) )
    op <- par(no.readonly = TRUE)


    elat = 90
    elon = 90
    ALONG = along.great(elat, elon, seq(from=10, to=180, by=10)*pi/180, 0)
    
    nsta = length(ALONG$phi)
    slat = ALONG$phi*180/pi
    slon = RPMG::fmod(ALONG$lam*180/pi, 360)
    H = cbind(rep(elat, times=nsta) , rep(elon, times=nsta), slat, slon, rep(35, length=nsta))
     
    par(mfrow= mfrow  )

    for(j in 1:length(MYPHS))
      {

        PHS =MYPHS[j]
        pathP = TAUP.RAYPATHS(H, PHASE=PHS, STANAMES=NULL, PLOT=FALSE)

        par(mai=c(0.1,0.1,0.1,0.1))
        DO.EARTH()
        ## abline(h=0)


        ## title(main=PHS)
        RPMG::label.it(a=PHS, corn=4, xpd=TRUE)

        ##   i = 10   

        for(i in 1:length(pathP))
          {
            if(is.null(pathP[[i]])) next

            g = RSEIS::GreatDist(H[i,2] , H[i,1] , pathP[[i]]$Rpath$lon, pathP[[i]]$Rpath$lat )

            flag = pathP[[i]]$Rpath$lon<0

            ex = cos(g$drad)
            why = sin(g$drad)

            why[flag] = -why[flag]

            ## pathP[[i]]$Rpath$rad

            lines(pathP[[i]]$Rpath$rad*ex, pathP[[i]]$Rpath$rad*why)

            ##points(pathP[[i]]$Rpath$rad[flag]*ex[flag], pathP[[i]]$Rpath$rad[flag]*why[flag], col='red')
            ##points(pathP[[i]]$Rpath$rad[flag]*ex[flag], pathP[[i]]$Rpath$rad[flag]*why[flag], col='green')

          }

        ##locator(1)

      }

    if(PS)dev.off()

    par(op)

  }




