addSTAINFO <- function(JINPUT, STA, origin=list(), DO.FE=FALSE)
  {
    if(missing(DO.FE))
      {
        DO.FE=FALSE

      }
    if(missing(origin))
      {
        origin = JINPUT[[1]]$DATTIM

    }

    
    unpackSACname<-function(bn)
        {
            ### bn is the basename of the SAC file
            fninfo = unlist( strsplit(bn, split="\\." ) )
            ## print( paste(fninfo, collapse=":") )
            fyr =  as.numeric(fninfo[1] )
            fjd=  as.numeric(fninfo[2] )
            fhr=  as.numeric(fninfo[3] )
            fmi=  as.numeric(fninfo[4] )
            fsec=  as.numeric(fninfo[5] )
            fmsec=  as.numeric(fninfo[6] )
            fnet = fninfo[7]
            fstn = fninfo[8]
            fstn2 = fninfo[9]
            fcomp = fninfo[10]

            if(is.null(fstn2))
                {
                    fstn2 = NA

                }
            LINFO = list(yr=fyr, jd=fjd, hr=fhr, mi=fmi, sec=fsec, msec=fmsec,
                net=fnet, stn=fstn, stn2=fstn2, comp=fcomp) 

            return(LINFO)
        }


    

    

    GetFEregion<-function(lat, lon)
        {
            if(!is.na(lat) & !is.na(lon))
                {
                    staplace = system(paste(sep=' ', FEREGION ,lon , lat), intern=TRUE)
                }
            else
                {
                    staplace = NA
                    
                }
          return(staplace)
        }

    
    FEREGION = system('which feregion.prl', intern =TRUE)
####   JINPUT is a list of wiggles from JSAC.seis
####  STA is a list of station information from a GSN list
####    CODE LATITUDE LONGITUDE ELEVATION NETWORK STATUS NAME

    jstns = sapply(JINPUT, '[[', 'sta')
    
    WSTA  = match(jstns, STA$CODE)

    ## check: cbind(jstns, STA$CODE[WSTA])
    ### initialize vectors
    stalat = vector(); stalon  = vector();  stael  =vector()
    staname  =vector(); stacomp  =vector(); stacomp2  =vector()
    stanet  =vector();  staplace  =vector()
    SD1 = vector();  SD2 = vector()
    
    for(ista in 1:length(JINPUT))
        {

            fn = JINPUT[[ista]]$fn

            ## file.path(fn, fsep = .Platform$file.sep)
            bn = basename(fn)
           ## print(paste(ista, bn)) 
            
            LINFO = unpackSACname(bn)

            
            d = JINPUT[[ista]]$DATTIM
            dt = JINPUT[[ista]]$dt
            N = JINPUT[[ista]]$N
            stn = JINPUT[[ista]]$sta
            
            wsta = which(stn==STA$CODE)
            
            SD1[ista] = RSEIS::secdif(origin$jd, origin$hr, origin$mi,
                   origin$sec, d$jd, d$hr, d$mi, d$sec)
            
            SD2[ista] = RSEIS::secdif(origin$jd, origin$hr, origin$mi,
                   origin$sec, d$jd, d$hr, d$mi, d$sec+N*dt)

            if(is.na(WSTA[ista] ) )
                {
                 ##   print(paste('?problem:', ista, wsta))

                    JINPUT[[ista]]$lat = NA
                    JINPUT[[ista]]$lon = NA
                    JINPUT[[ista]]$el  = NA
                    
                    JINPUT[[ista]]$CODE  = JINPUT[[ista]]$sta
                    JINPUT[[ista]]$nameID  = NA
                    JINPUT[[ista]]$NETWORK  = NA
                    JINPUT[[ista]]$LINFO = LINFO
                    
                    if( is.numeric(JINPUT[[ista]]$coords$reclat) ) JINPUT[[ista]]$lat=JINPUT[[ista]]$coords$reclat
                    if( is.numeric(JINPUT[[ista]]$coords$reclon) ) JINPUT[[ista]]$lon=JINPUT[[ista]]$coords$reclon
                    if( is.numeric(JINPUT[[ista]]$coords$recel) )
                        {
                            JINPUT[[ista]]$el=JINPUT[[ista]]$coords$recel/1000
                        }

                }
            else
                {
                    
                    JINPUT[[ista]]$lat = STA$LATITUDE[wsta]
                    JINPUT[[ista]]$lon = STA$LONGITUDE[wsta]
                    JINPUT[[ista]]$el  = STA$ELEVATION[wsta]


                    if( is.numeric(JINPUT[[ista]]$coords$reclat) ) JINPUT[[ista]]$lat=JINPUT[[ista]]$coords$reclat
                    if( is.numeric(JINPUT[[ista]]$coords$reclon) ) JINPUT[[ista]]$lon=JINPUT[[ista]]$coords$reclon
                    if( is.numeric(JINPUT[[ista]]$coords$recel) )
                        {
                            if(JINPUT[[1]]$IO$kind==2)
                                {
                                    JINPUT[[ista]]$el=JINPUT[[ista]]$coords$recel/1000
                                }
                            else
                                {

                                    JINPUT[[ista]]$el=JINPUT[[ista]]$coords$recel
                                }
                        }
                    
                    JINPUT[[ista]]$CODE  = STA$CODE[wsta]
                    JINPUT[[ista]]$nameID  = STA$NAME[wsta]
                    JINPUT[[ista]]$NETWORK  = STA$NETWORK[wsta]
                    JINPUT[[ista]]$LINFO = LINFO
                }


            stalat[ista] = JINPUT[[ista]]$lat
            stalon[ista] = JINPUT[[ista]]$lon
            stael[ista]  = JINPUT[[ista]]$el
            staname[ista]  = JINPUT[[ista]]$CODE
            stacomp[ista]  = JINPUT[[ista]]$comp
            stacomp2[ista]  = JINPUT[[ista]]$LINFO$stn2
            stanet[ista]  = JINPUT[[ista]]$NETWORK
            
            staplace[ista] = NA

            if(DO.FE){  staplace[ista]  = GetFEregion(JINPUT[[ista]]$lat, JINPUT[[ista]]$lon) }
        }


  ##  jstns = sapply(J, '[[', 'sta')
  ##   jlat  = sapply(J, '[[', 'lat')
    
    
    attr(JINPUT, "staname")<-staname
    attr(JINPUT, "stalat")<-stalat
    attr(JINPUT, "stalon")<-stalon
    attr(JINPUT, "stael")<-stael
    attr(JINPUT, "staplace")<-staplace
    attr(JINPUT, "startT")<- SD1
    attr(JINPUT, "endT")<- SD2

    attr(JINPUT, "stanet")<-stanet
    attr(JINPUT, "stacomp")<-stacomp
    attr(JINPUT, "stacomp2")<-stacomp2
    
    invisible(JINPUT)
    
  }

