breqfast1<-function(DATIN , fout="JMLbreq.send", breqHEAD =vector("") , TLEN = 3600 , chans=c("BHZ", "BHN", "BHE") , ftpfile="JMLbreq")
  {
##########  DATIN is a dataframe (list) with the relevant information for requests
    if(missing(fout))   fout="JMLbreq.send"
    if(missing(ftpfile)) ftpfile = "JMLbreq"
    if(missing(chans))  chans=c("BHZ", "BHN", "BHE")
    if(missing(breqHEAD))
      {
        breqHEAD = 
          c(".NAME Jonathan Lees",
            ".INST Geological Sciences, University of North Carolina, CH",
            ".MAIL CB 3315, Chapel Hill NC 27599-3315",
            ".EMAIL jonathan.lees@unc.edu",
            ".PHONE 919 962-1562",
            ".FAX   919 966-4519",
            ".MEDIA: FTP",
            ".ALTERNATE MEDIA: DAT",
            ".ALTERNATE MEDIA: EXABYTE")

      }
    if(missing(TLEN))TLEN = 3600   


    cat(file=fout,breqHEAD[1], sep="\n" , append = FALSE)
    for(i in 2:length(breqHEAD))
      {
        cat(file=fout, breqHEAD[i], sep="\n", append =TRUE)
      }
    
    
    cat(file=fout,paste(sep=" ", ".LABEL", ftpfile), sep="\n", append =TRUE)
    cat(file=fout,".END", sep="\n", append =TRUE)
    cat(file=fout,"", sep="\n", append =TRUE)
    
#######   TLEN = 3*60*60   ##########    3 hours  

    nchans = length(chans)
    
    for(i in 1:length(DATIN$sta))
      {
        
        AT =  RSEIS::recdate(jd=DATIN$jd[i], hr=DATIN$hr[i], mi=DATIN$mi[i], sec=DATIN$sec[i], yr=DATIN$yr[i])
        BT =  RSEIS::recdate(jd=DATIN$jd[i], hr=DATIN$hr[i], mi=DATIN$mi[i], sec=DATIN$sec[i]+TLEN, yr=DATIN$yr[i])
        
        dom1 = RSEIS::getmoday(AT$jd, DATIN$yr[i])
        dom2 = RSEIS::getmoday(BT$jd, DATIN$yr[i])
        

        THEtime =   paste(sep=" ",format(DATIN$sta[i], width=4),
          format(DATIN$net[i],width=2),
          formatC(DATIN$yr[i], format="d", digits=4, width=4),
          formatC(dom1$mo, format="d", digits=2, width=2),
          formatC(dom1$dom, format="d", digits=2, width=2),
          formatC(AT$hr, format="d", digits=2, width=2),
          formatC(AT$mi, format="d", digits=2, width=2),
          formatC(AT$sec, format="f", digits=1, width=4),
          formatC(DATIN$yr[i], format="d", digits=4, width=4),
          formatC(dom2$mo, format="d", digits=2, width=2),
          formatC(dom2$dom, format="d", digits=2, width=2),
          formatC(BT$hr, format="d", digits=2, width=2),
          formatC(BT$mi, format="d", digits=2, width=2),
          formatC(BT$sec, format="f", digits=1, width=4))

        cat(file=fout, THEtime , sep="  ", append =TRUE)

        
        cat(file=fout,paste(sep=" ", " ", nchans), sep="", append =TRUE)

            for(k in 1:nchans) cat(file=fout, paste(sep=" ", " ",chans[k]) , sep=" ", append =TRUE)
        cat(file=fout, "", sep="\n", append =TRUE)

      }
    
  ##   cat(file=fout,"", sep="\n", append =TRUE)
  }



##  breqfast1("TEMPOUT")
