\name{DECIM}
\alias{DECIM}
\title{Decimate time series 
}
\description{Decimate time series for faster plotting
}
\usage{
DECIM(TH, sel = 1:length(TH), fh = 10, dec = 5)
}
\arguments{
  \item{TH}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
  \item{sel}{numeric index vector selection of traces to display
}
  \item{fh}{ high frequency cut off for low pass filter, NA = no filter applied(default)
}
  \item{dec}{decimation number: return every dec index sample
}
}
\details{ DECIM will return time series decimated by the
  parameter dec: a value of 10 will return a tenth of
  the number of samples.  The first sample of each trace remains
  the same so the start time is not modified.  DeltaT is adjusted in
  each time series.
}
\value{List of Seismograms, as in JSAC.seis or JSEGY.seis,
  with the waveforms decimated, the delta-t values are adjusted.
  
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Used for plotting primarily.
}

\examples{

\dontrun{
wigdir = "/home/lees/XMDEMO_R/HAITI/WIGS"
GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
FEREGION = "/home/lees/Progs/Perl/feregion.prl"
IASPHOME="/home/lees/Progs/TTIMES"
event=list(
yr=2010,
mo=1,
dom=12,
hr=21,
mi=53,
sec=10.0600	,
lat=18.443,	
lon= -72.571,
mag=7.0	,
depth=13.0)

event$z =event$depth

event$jd = getjul(event$yr, event$mo, event$dom)

fwigs = list.files(path=wigdir, pat="SAC", full.names=TRUE)



STA = scan(file=GSNstalist, skip=1, sep=",", what=list(CODE="",LATITUDE=0,LONGITUDE=0,ELEVATION=0,NETWORK="",STATUS="",NAME=""), flush=TRUE, quote=NULL)


J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT =
-1 )
DJ = DECIM(J, fh=NA, dec=10)
}

}
\keyword{misc}
