\name{GET.TTCURVES}
\alias{GET.TTCURVES}
\title{Get Travel Time Curves
}
\description{Get global travel time curves
  using the iasp91 model.
}
\usage{
GET.TTCURVES(Z = 35, DIS = seq(from = 5, to = 180, by = 5), IASPHOME = "")
}
\arguments{
  \item{Z}{depth of source, km
}
  \item{DIS}{vector of distances in degrees
}
\item{IASPHOME}{Path to directory where
  Kennet-Engdahl code resides
}
}
\details{
  Kennet-Engdahl code must be installed
  and executable via system call.
  To set this fortran code up, see notes.
  
}
\value{List of arrival times based on phases.
}
\references{


  Buland, R., and C. H. Chapman (1983). The computation of seismic
  travel times. Bulletin of the Seismological Society of America
  73,1,271 -1,302.

  Crotwell, H. P., T. J. Owens, and J. Ritsema (1999). The TauP Toolkit:
  Flexible seismic travel-time and ray-path utilities. Seismological
  Research Letters 70, 154-160.

  Kennett, B. L. N., and E. R. Engdahl (1991). Traveltimes for global
  earthquake location and phase identification. Geophysical Journal
  International 122,429 -465.
  
  


  
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  Path is /home/lees/Progs/TTIMES.  See example for installation
  instructions.
}


\seealso{ADDttcurves
}
\examples{


###########   copy /home/lees/Progs/TTIMES
##### get this tar file:
#####  /home/lees/Progs/TTIMES_2009.10.19.tar.gz

##### unpack this
##### tar zxvf TTIMES_2009.10.19.tar.gz
##### cd TTIMES
##### make cleanall
##### make all
##### remodl
##### setbrn


\dontrun{


IASPHOME="/home/lees/Progs/TTIMES"
DIS  = seq(from=5, to=180, by=5)

TTCURVES = GET.TTCURVES(Z=8, DIS= seq(from=5, to=180, by=2))

plot(c(0,180), c(0, 3500), type='n')

ADDttcurves(TTCURVES, sel = "all" , col = grey(0.6))

}




}
\keyword{misc}
