\name{IDARRIVAL}
\alias{IDARRIVAL}
\alias{label.ttcurves}
\alias{labelIDiasp91}

\title{Identify and Label Arrivals
}
\description{Identify travel time Arrivals interactively from plot.
}
\usage{
IDARRIVAL(TTCURVES, KLOC=list())
label.ttcurves(TTCURVES, sel=1:2 )
labelIDiasp91(TTCURVES, cex=0.7)
}
\arguments{
  \item{TTCURVES}{List of travel time curves
  }
  \item{KLOC}{(x,y)  list of locations on plot }
  \item{sel}{ numeric selection of which labels to plot }
  \item{cex}{ character expansion for labels }
  
}
\details{After plotting and adding travel time
  curves use this function to find the names of the curves.
  if KLOC is missing,
  uses locator, so keep clicking until done (middle mouse)
  then the plot will show nearest arrival names.

  For label.ttcurves the labels are apply automatically
  at the  median position in the plot.
}
\value{Graphical Side Effects
}
\references{

Buland, R., and C. H. Chapman (1983). The computation of seismic
  travel times. Bulletin of the Seismological Society of America
  73,1,271 -1,302.

  Kennett, B. L. N., and E. R. Engdahl (1991). Traveltimes for global
  earthquake location and phase identification. Geophysical Journal
  International 122,429 -465.
  
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{GET.TTCURVES, ADDttcurves, PrepGSNdisplay
}
\examples{


\dontrun{
###  interactive program, uses locator()
DIS  = seq(from=5, to=180, by=5)

TTCURVES = GET.TTCURVES(Z=8, DIS= seq(from=5, to=180, by=2))

plot(c(0,180), c(0, 3500), type='n')

ADDttcurves(TTCURVES, sel = "all" , col = grey(0.6))
IDARRIVAL(TTCURVES)



}



}
\keyword{misc}
