\name{PGSNinfo}
\alias{PGSNinfo}
\title{Print GSN station information to Screen
}
\description{Print GSN station information to Screen
}
\usage{
PGSNinfo(J)
}
\arguments{
  \item{J}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
}

\value{Side Effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\examples{
\dontrun{
wigdir = "/home/lees/XMDEMO_R/HAITI/WIGS"
GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
FEREGION = "/home/lees/Progs/Perl/feregion.prl"
IASPHOME="/home/lees/Progs/TTIMES"
event=list(
yr=2010,
mo=1,
dom=12,
hr=21,
mi=53,
sec=10.0600	,
lat=18.443,	
lon= -72.571,
mag=7.0	,
depth=13.0)

event$z =event$depth

event$jd = getjul(event$yr, event$mo, event$dom)

fwigs = list.files(path=wigdir, pat="SAC", full.names=TRUE)



STA = scan(file=GSNstalist, skip=1, sep=",", what=list(CODE="",LATITUDE=0,LONGITUDE=0,ELEVATION=0,NETWORK="",STATUS="",NAME=""), flush=TRUE, quote=NULL)


J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT =
-1 )

J = addSTAINFO(J, STA)


PGSNinfo(J)
}

}
\keyword{misc}
