\name{PrepGSNdisplay}
\alias{PrepGSNdisplay}
\title{Prepare Seismic display
}
\description{Prepare Seismic display for global
  event, time versus distance in degrees.
}
\usage{
PrepGSNdisplay(JINPUT, WUSE, event, TTCURVES = list(), xlim=c(0,180), ylim=c(0, 4000))
}
\arguments{
  \item{JINPUT}{List of Seismograms, as in JSAC.seis or JSEGY.seis
}
  \item{WUSE}{numeric index vector selection of traces to display
}
  \item{event}{Event structure with location and time of source
}
  \item{TTCURVES}{List of travel time curves
  }
  \item{xlim}{Limits on the x-axis (degrees)
  }
    \item{ylim}{Limits on the y-axis, time (s)
  }

  
}
\details{This code sets up the graphical window
  for further plotting.
  
}
\value{Graphical side effects.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{GET.TTCURVES, ADDTRACES, IDTRACE
}
\examples{

\dontrun{
wigdir = "/home/lees/XMDEMO_R/HAITI/WIGS"
GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
FEREGION = "/home/lees/Progs/Perl/feregion.prl"
IASPHOME="/home/lees/Progs/TTIMES"
event=list(
yr=2010,
mo=1,
dom=12,
hr=21,
mi=53,
sec=10.0600	,
lat=18.443,	
lon= -72.571,
mag=7.0	,
depth=13.0)

event$z =event$depth

event$jd = getjul(event$yr, event$mo, event$dom)

fwigs = list.files(path=wigdir, pat="SAC", full.names=TRUE)



STA = scan(file=GSNstalist, skip=1, sep=",", what=list(CODE="",LATITUDE=0,LONGITUDE=0,ELEVATION=0,NETWORK="",STATUS="",NAME=""), flush=TRUE, quote=NULL)


J = JSAC.seis(fwigs, Iendian = 3 , HEADONLY=FALSE, BIGLONG=FALSE, PLOT = -1)

H = addSTAINFO(J, STA)
J = H

names(attributes(J))
stalat = attr(H, "stalat")
staname = attr(H, "staname")
TTCURVES = GET.TTCURVES(Z=event$depth, DIS= seq(from=5, to=180, by=2), IASPHOME=IASPHOME)
WUSE = which(!is.na(stalat) & !duplicated(staname) )

dev.set(2)
PrepGSNdisplay(J, WUSE, event, TTCURVES=NA)

}


}
\keyword{misc}
\keyword{aplot}