\name{SurfaceWaves}
\alias{SurfaceWaves}
\title{Add surface wave arrival times to GSN plot
}
\description{Add surface wave arrival times to GSN plot.
}
\usage{
SurfaceWaves(V = seq(from = 2, to = 5, length = 10),
Ddeg = seq(from =0, to = 180, by = 2), TIntercept=0 , col=rgb(1, .6,.6),   add = TRUE)
}
\arguments{
  \item{V}{vector of velocities to plot
}
  \item{Ddeg}{vector of Decimal degrees 
}

  \item{TIntercept}{Time Intercept, default = 0
  }
  \item{col}{vector of colors for plotting
  }
    \item{add}{logical, TRUE = add to existing plot
  }
}
\details{
  surface waves travel in a linear
  fashion with a given velocity.
  Since a vector is provided,
  several paths acan be shown at once.
  Rayleigh waves are assumed to
  by 0.9 times the love wave speeds.
  for body waves use ttimes.
  
}
\value{
  list:
  \item{Ddeg}{Decimal degrees}
  \item{Tlove}{Love wave arrivals}
  \item{Trayl}{Rayleigh wave arrivals}

  
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{PrepGSNdisplay,  ttimes  
}
\examples{

\dontrun{
TTCURVES = GET.TTCURVES(Z=35, DIS= seq(from=5, to=180, by=2))

plot(x=c(0, 180), y=c(0, 12000), type='n', xlab="Degrees", ylab="Time, s")
ADDttcurves(TTCURVES, sel="all" , col=grey(.6) )

SurfaceWaves()
SurfaceWaves(V = -4,  Ddeg = seq(from=180, to=0, by=-2),
TIntercept=6371*360*pi/180/(4) , col="green" ,  add=TRUE )

##############    or zoomed in slightly:
APAL = GPAL()


plot(x=c(0, 180), y=c(0, 4000), type='n', xlab="Degrees", ylab="Time, s")
ADDttcurves(TTCURVES, sel="all" , col=grey(.6) )
V = seq(from=4, to=8, length=10)
SurfaceWaves(V, col=APAL[1:length(V)] )


}

}
\keyword{misc}
