\name{TAUP.RAYPATHS}
\alias{TAUP.RAYPATHS}
\title{Tau-P Raypaths
}
\description{Extract Tau-P raypaths
  for sets of lat-lon pairs using Iaspei-91 velocity model
}
\usage{
TAUP.RAYPATHS(H, PHASE = "P", STANAMES = NULL, PLOT = FALSE)
}
\arguments{
  \item{H}{matrix, station: columns 1,2; event columns 3,4,5
}
  \item{PHASE}{Choose a phase, default="P"
}
  \item{STANAMES}{names for the given stations
}
  \item{PLOT}{logical, TRUE=plot raypaths
}
}
\details{Uses the Java script developed by U. S. Carolina, Phil Crotwell.
}
\value{Writes to a file, the file is read in a
  a list of ray paths is provided.
  these consist of lists:
  \item{sta}{station name}
  \item{phase}{Phase requested}
  \item{tt}{travel time, s}
  \item{deg}{distance in degrees}
  \item{depth}{depth of event}
  \item{rayparam}{Seismic Rayparameter}
  \item{Rpath}{list of d, rad, lat, lon for the ray path}
}
\references{

 Crotwell, H. P., T. J. Owens, and J. Ritsema (1999). The TauP Toolkit:
  Flexible seismic travel-time and ray-path utilities. Seismological
  Research Letters 70, 154-160.


  
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{Uses Ssytem calls to external programs.
}


\seealso{iasp91, DO.EARTH, GET.TTCURVES
}
\examples{

\dontrun{
library(RPMG)
library(RSEIS)
library(GEOmap)

##   need these installed and  set first

## set path=(/opt/jdk1.5.0_07/bin /home/merlot/DOWNLOAD/TauP-1.2beta3/bin /home/lees/Bware/e3d/bin $path)
## setenv TAUP_HOME /home/merlot/DOWNLOAD/TauP-1.2beta3

elat = 90
elon = 90
ALONG = along.great(elat, elon, seq(from=10, to=180, by=10)*pi/180, 0)

nsta = length(ALONG$phi)
slat = ALONG$phi*180/pi
slon = RPMG::fmod(ALONG$lam*180/pi, 360)

event=list(yr=2010, mo=1, dom=12, hr=21, mi=53, sec=10.0600,
lat=elat,lon=elon ,mag=7.0, depth=13.0, z=13.0)

H = cbind(rep(elat, times=nsta) , rep(elon, times=nsta), slat, slon, rep(event$z, length=nsta))


MYPHS = c("P", "S", "PP", "SKS", "PKiKP", "PcP", "pP", "pPdiff", "pPKiKP", "sP", "sPdiff","sPKiKP")
par(mfrow=c(4,4))

for(j in 1:length(MYPHS))
{

PHS =MYPHS[j]
pathP = TAUP.RAYPATHS(H, PHASE=PHS, STANAMES=NULL, PLOT=FALSE)

par(mai=c(0.1,0.1,0.1,0.1))
DO.EARTH()
## abline(h=0)


## title(main=PHS)
label.it(a=PHS, corn=4)

##   i = 10   

for(i in 1:length(pathP))
{
if(is.null(pathP[[i]])) next

g = RSEIS::GreatDist(H[i,2] , H[i,1] , pathP[[i]]$Rpath$lon, pathP[[i]]$Rpath$lat )

flag = pathP[[i]]$Rpath$lon<0

ex = cos(g$drad)
why = sin(g$drad)

why[flag] = -why[flag]

## pathP[[i]]$Rpath$rad

lines(pathP[[i]]$Rpath$rad*ex, pathP[[i]]$Rpath$rad*why)

##points(pathP[[i]]$Rpath$rad[flag]*ex[flag], pathP[[i]]$Rpath$rad[flag]*why[flag], col='red')
##points(pathP[[i]]$Rpath$rad[flag]*ex[flag], pathP[[i]]$Rpath$rad[flag]*why[flag], col='green')

}

##locator(1)

}




}



}
\keyword{misc}
