\name{TELES-package}
\alias{TELES-package}
\alias{TELES}
\docType{package}
\title{
    Global Seismic Teleseismic Display
}
\description{
  Sets up data and displays events
  from global seismic records.
}
\details{

Reads in Seismic data that can be downloaded from NEIC, IRIS
or other web sites that distribute wave form data in SAC, SEGY,
or SEED format.

}
\author{
  Jonathan M. Lees<jonathan.lees.edu>
Maintainer:Jonathan M. Lees<jonathan.lees.edu>
}
\references{
  Buland, R., and C. H. Chapman (1983). The computation of seismic
  travel times. Bulletin of the Seismological Society of America
  73,1,271 -1,302.

  Crotwell, H. P., T. J. Owens, and J. Ritsema (1999). The TauP Toolkit:
  Flexible seismic travel-time and ray-path utilities. Seismological
  Research Letters 70, 154-160.

  Kennett, B. L. N., and E. R. Engdahl (1991). Traveltimes for global
  earthquake location and phase identification. Geophysical Journal
  International 122,429 -465.
  
  
}

\keyword{ package }
\seealso{
RSEIS, GEOmap, RFOC
}
\examples{
\dontrun{

library(TELES)

SSINF = Sys.info()

if(SSINF[1]=="Darwin")
  {
    ############  MAC
    wigdir = "/Users/lees/XMDEMO_R/HAITI/WIGS3"
    GSNstalist = "/Users/lees/HHHH/station_comma_list.asc"
    FEREGION = "/Users/lees/Progs/Perl/feregion.prl"
    IASPHOME="/Users/lees/Progs/TTIMES"

    
  } else  {
    #################  LINUX
    wigdir = "/home/lees/XMDEMO_R/HAITI/WIGS3"
    GSNstalist = "/home/lees/XMDEMO_R/station_comma_list.asc"
    FEREGION = "/home/lees/Progs/Perl/feregion.prl"
    IASPHOME="/home/lees/Progs/TTIMES"

  }

event=list(yr=2010, mo=1, dom=12, hr=21, mi=53, sec=10.0600,
lat=18.443,lon= -72.571,mag=7.0, depth=13.0, z=13.0)

event$jd = getjul(event$yr, event$mo, event$dom)

fwigs = list.files(path=wigdir, pat="SEGY", full.names=TRUE)

fwigs = fwigs[ grep("BHZ", fwigs) ]

WDAT = splitGSNnames(fwigs)

ustas1 = unique(paste(sep=".", WDAT$stn, WDAT$stn2))
ustas = unique(paste(sep=".", WDAT$stn, WDAT$stn2))

data(STA)

Jhead = JSEGY.seis(fwigs, Iendian = 1 ,
       HEADONLY=TRUE, BIGLONG=FALSE, PLOT = -1)
J = JSEGY.seis(fwigs, Iendian = 1 ,
            HEADONLY=FALSE, BIGLONG=FALSE, PLOT = -1 )

J = addSTAINFO(J, STA)

ustas = unique(WDAT$stn)


WUSE = 1:length(J)

TTCURVES = GET.TTCURVES(Z=event$depth,
         DIS= seq(from=1, to=180, by=2), IASPHOME=IASPHOME)

###   graphics.off()


GSNplot(J, WUSE ,event, TTCURVES ,demo = FALSE, decim=20 )
############################################################
#####################################################################


GreatCirclePlot(J, event, WUSE= 1:length(J), col=NA)
############################################################
#####################################################################



}


}
