\name{TL}
\alias{TL}
\docType{data}
\title{
TeleSeismic data structure
}
\description{
One station from the TA array in March, 2011, that
recorded the Tohoku-Iki event.
}
\usage{data("TL")}
\format{
  The format is:
List of 19
 $ JSTR       :List of 3
  ..$ : num [1:199381] NA NA NA NA NA NA NA NA NA NA ...
  ..$ : num [1:199381] -1.90e-07 -1.89e-07 -1.87e-07 -1.84e-07 -1.79e-07 ...
  ..$ : num [1:199381] NA NA NA NA NA NA NA NA NA NA ...
 $ STNS       : chr [1:3] "034A" "034A" "034A"
 $ dir        : chr "034A_BHZ_2011:070:05:48:44:000.RDATA"
 $ ifile      : chr "034A_BHZ_2011:070:05:48:44:000.RDATA"
 $ COMPS      : chr [1:3] "V" "N" "E"
 $ OCOMPS     : chr [1:3] "BHZ" "BHN" "BHE"
 $ dt         : num [1:3] 0.025 0.025 0.025
 $ KNOTES     : chr [1:3] "034A BHZ" "034A BHN" "034A BHE"
 $ info       :List of 20
  ..$ fn      : chr [1:3] "034A_BHZ_2011:070:05:48:44:000.RDATA" "034A_BHN_2011:070:05:47:25:400.RDATA" "034A_BHE_2011:070:05:48:43:825.RDATA"
  ..$ name    : chr [1:3] "034A_BHZ_2011:070:05:48:44:000.RDATA" "034A_BHN_2011:070:05:47:25:400.RDATA" "034A_BHE_2011:070:05:48:43:825.RDATA"
  ..$ yr      : num [1:3] 2011 2011 2011
  ..$ jd      : num [1:3] 70 70 70
  ..$ mo      : num [1:3] 3 3 3
  ..$ dom     : int [1:3] 11 11 11
  ..$ hr      : int [1:3] 5 5 5
  ..$ mi      : int [1:3] 48 47 48
  ..$ sec     : num [1:3] 44 25.4 43.8
  ..$ msec    : num [1:3] 0 0 0
  ..$ dt      : num [1:3] 0.025 0.025 0.025
  ..$ t1      : num [1:3] 0 0 0
  ..$ t2      : num [1:3] 4984 4984 4984
  ..$ off     : num [1:3] 78.6 0 78.4
  ..$ n1      : num [1:3] 199381 199381 199381
  ..$ n2      : num [1:3] 199381 199381 199381
  ..$ n3      : num [1:3] 199381 199381 199381
  ..$ n       : num [1:3] 199381 199381 199381
  ..$ gain    : num [1:3] 1 1 1
  ..$ scalefac: num [1:3] 1 1 1
 $ dat        : NULL
 $ nn         : int 3
 $ ex         : num [1:199381] 0 0.025 0.05 0.075 0.1 0.125 0.15 0.175 0.2 0.225 ...
 $ pcol       : num [1:3] 1 1 1
 $ ok         : int [1:3] 3 2 1
 $ wintim     : num 70.2
 $ ftime      : chr [1:3] "2011_3_11_5_48_44_0" "2011_3_11_5_47_25.4000000953674_0" "2011_3_11_5_48_43.8250000476837_0"
 $ units      : chr [1:3] "volts" "volts" "volts"
 $ event      :List of 12
  ..$ yr   : num 2011
  ..$ mo   : num 3
  ..$ dom  : int 11
  ..$ hr   : int 5
  ..$ mi   : int 46
  ..$ sec  : num 23
  ..$ jd   : num 70
  ..$ lat  : num 38.3
  ..$ lon  : num 142
  ..$ mag  : num 9.1
  ..$ depth: num 19.7
  ..$ z    : num 19.7
 $ stationlist:List of 4
  ..$ name: chr "034A"
  ..$ lat : num 27.1
  ..$ lon : num -98.7
  ..$ z   : num 0.155
}
\details{
Three component seismic data at station 034A (Hebronville, Texas) with event location and
and station location.

}
\source{
IRIS-DMC
}

\examples{
data(TL)

RSEIS::swig(TL, SHOWONLY=0)

##
}
\keyword{datasets}
