\name{doc.ttar}
\alias{doc.ttar}

\title{Documentation for travel time arrivals }
\description{
Prints brief documentation for buttons in GSNplot
}
\usage{
doc.ttar(TTCURVES, sel="named" )
}

\arguments{
  \item{TTCURVES}{travel time curves }
  \item{sel}{selected travel time phases }
}
\details{

  Selected travel times are based on the available
  documentation.  If a phase does not have documentation
  as listed in phasedoc, do not supply as a choice.

}
\value{
printed side effect
}

\author{Jonathan M. Lees<jonathan.lees.edu>}

\seealso{GSNplot}
\examples{

\dontrun{

 IASPHOME="/home/lees/Progs/TTIMES"



event=list(yr=2010, mo=1, dom=12, hr=21, mi=53, sec=10.0600,
lat=18.443,lon= -72.571,mag=7.0, depth=13.0, z=13.0)

event$jd = getjul(event$yr, event$mo, event$dom)


TTCURVES = GET.TTCURVES(Z=event$depth, DIS= seq(from=1, to=180, by=2), IASPHOME=IASPHOME)

doc.ttar(TTCURVES, sel="named")

}



}

\keyword{misc}
