`Laker` <-
function(MAPtest, MAPbase, Wbase=1, Wtest=1)
  {
    if(missing(Wbase))   Wbase =  which(MAPbase$STROKES$code=="c")
    if(missing(Wtest))   Wtest =  which(MAPtest$STROKES$code=="c")

    gin = rep(FALSE, length(Wtest))
    Bstrok = rep(0, length(Wtest))

    TLAT1 = MAPtest$STROKES$LAT1[Wtest]
    TLAT2 = MAPtest$STROKES$LAT2[Wtest]
    TLON1 = MAPtest$STROKES$LON1[Wtest]
    TLON2 = MAPtest$STROKES$LON2[Wtest]

    
    for(i in 1:length(Wbase))
      {
        jbase = Wbase[i]

        blat1 = MAPbase$STROKES$LAT1[jbase]
        blon1 = MAPbase$STROKES$LON1[jbase]
        blat2 = MAPbase$STROKES$LAT2[jbase]
        blon2 = MAPbase$STROKES$LON2[jbase]

        proj = setPROJ(2, LON0=blon1, LAT0=blat1)

        j1 = MAPbase$STROKES$index[jbase]+1
        j2 = j1+MAPbase$STROKES$num[jbase]-1
        JJEC = j1:j2

        BaseLATS = MAPbase$POINTS$lat[JJEC]
        BaseLONS = MAPbase$POINTS$lon[JJEC]



        
        BASXY  = GLOB.XY( BaseLATS, BaseLONS, proj)

        Rx = range(BASXY$x)
        Ry = range(BASXY$y)

        

         RLL = GLOB.XY(TLAT1 , TLON1, proj)
         RUR = GLOB.XY(TLAT2 , TLON2, proj)

        

        W2 =
          which(RLL$x>=Rx[1]&RLL$x<=Rx[2] &  RLL$y>=Ry[1]&RLL$y<=Ry[2]  |
                RUR$x>=Rx[1]&RUR$x<=Rx[2] &  RUR$y>=Ry[1]&RUR$y<=Ry[2]  |
                RUR$x>=Rx[1]&RUR$x<=Rx[2] &  RLL$y>=Ry[1]&RLL$y<=Ry[2]  |
                RLL$x>=Rx[1]&RLL$x<=Rx[2] &  RUR$y>=Ry[1]&RUR$y<=Ry[2]  )
        

        print(paste(i, jbase, length(W2))   )
        if(length(W2)<1) next
        for(iw in 1:length(W2))
          {
            jj1 = W2[iw]
            jj2 =  Wtest[jj1]

            if(jj2>0 & jbase>0 )

              {
            
            zin =  GEOinout(MAPtest,  NTEST=jj2,
              MAPBASE=MAPbase, NBASE=jbase, SHOWIT=FALSE)

            if(zin)
              {
                gin[jj1]  = TRUE
                Bstrok[jj1] = jbase
              }

          }
            
          }

      }
    
    
    
    return(list(gin=gin, Bstrok = Bstrok))

  }

