MAPsel3<-function(coast3,  LIM = c(268.156300,   7.593004, 305.000000,  25.926045), PROJ =PROJ)
  {
###   function to extract strokes from the coast3 database
      coastmap=coast2=coast3=coast4=NULL
      
    G = GEOmap::GLOB.XY(c(LIM[2], LIM[4]), c(LIM[1], LIM[3]), PROJ =PROJ)

    plot(range(G$x), range(G$y), type='n', ann=FALSE, axes=FALSE, asp=1)
    GEOmap::plotGEOmapXY(coast2 ,  LIM = LIM, PROJ =PROJ, MAPstyle = 2,   MAPcol = grey(0.8)  ,  add=TRUE )

    GEOmap::plotGEOmapXY(coast3 ,  LIM = LIM, PROJ =PROJ,  add=TRUE )


    MAPXY = GEOmap::GLOB.XY(coast3$POINTS$lat ,  RPMG::fmod( coast3$POINTS$lon, 360) , PROJ )


    L = locator(type='p', col='red', pch=3)

      JINDEX = vector()
    J = 0
  
    for(j in seq(from=1, to=length(L$x), by=2))
      {

        p1 = list(x=min(c(L$x[j],L$x[j+1])),  y=min(c(L$y[j], y=L$y[j+1])))
        p2 = list(x=max(c(L$x[j],L$x[j+1])),  y=max(c(L$y[j], y=L$y[j+1])))
        
     

        rect(L$x[j], L$y[j], L$x[j+1], L$y[j+1], border=rgb(.8, 1, .8))
      
        
        for(i in 1:length(coast3$STROKES$index))
          {
            j1 = coast3$STROKES$index[i]+1
            j2 = j1+coast3$STROKES$num[i]-1


            JEC = j1:j2
            x = MAPXY$x[JEC]
            y = MAPXY$y[JEC]

            ## lines(x,y, col="purple")

            if(any(x>=p1$x & x<=p2$x & y>=p1$y & y<=p2$y))
              {
                lines(x,y, col="purple")
                J = J + 1 
                JINDEX[J] = i
              }

          }


      }


    invisible(JINDEX)
  }


