`checkworld` <-
function(LAT1=0, LAT2=36, LON1=0, LON2=360, bydeg=36, MAP1=coast2, MAP2=NULL )
{
coastmap=coast2=coast3=coast4=NULL
  if(missing(MAP1))
    {
      data(coast2, package ="WORLDMAP2" )
      MAP1 = coast2
      
    }
  if(missing(MAP2))
    {
      
      data(coast3, package ="WORLDMAP2")
      MAP2 = coast3
    }
  
  bydeg = 36
  if(missing(bydeg)) bydeg = 36
  if(missing(LAT1)) LAT1=0
  if(missing(LAT2)) LAT2=bydeg
  if(missing(LON1)) LON1=0
  if(missing(LON2)) LON2=360
  
  for(i in seq(from=LON1, to=LON2, by=bydeg))
    {
      LON1 = i
      LON2 = i+bydeg
      proj = GEOmap::setPROJ(2, LON0=mean(c(LON1, LON2) ) , LAT0=mean(c(LAT1,LAT2 )) )
      LIM=c(LON1, LAT1,LON2, LAT2 )
      coastmapXY(MAP1, LIM=LIM, PROJ=proj,
                 add=FALSE , xlab="", ylab="")

      if(!is.null(MAP2))
        {
          coastmapXY(MAP2,  LIM=LIM, PROJ=proj,
                     add=TRUE, border='black' )
        }
      
      
      title(main="Click map", sub=paste(LIM, collapse=" ") )
      
      
      locator(1)
    }
  return(list(proj=proj, LIM=c(LON1, LAT1,LON2, LAT2 )))
  
  
}

