`matchGEOmaps` <-
function(MAP1, MAP2, istart=1, iend=1, checkind=100, savefile="JEEZ.RDATA" )
  {
    if(missing(istart)) {  istart=1  }
    
    
    if(missing(checkind)) {  checkind=100  }
    if(missing(savefile)) {  savefile="JEEZ.RDATA"  }
    
########  check all the strokes in
########    MAP2 to see if those points are already in MAP1
    ####  if they are set to 1, else 0
    checkind = 100
    
    Kmap = length(MAP2$STROKES$num)

    if(missing(iend)) {  iend=Kmap  }
    
    print(paste(sep=" " , "Working on a total of ", Kmap, "strokes" )) 
    JEEZ = rep(0, Kmap)
    for(i in istart:iend)
      {
        j1 = MAP2$STROKES$index[i]+1
        j2 = j1+MAP2$STROKES$num[i]-1

        if(j1>0 & j2>0 & j2-j1 >=0)
          {
            JEC = j1:j2
          }
        else
          {
            next
          }

            LATS = MAP2$POINTS$lat[JEC]
        ## lons = MAP2$POINTS$lon[j1:j2]
        
        ITF  = all(!is.na(match(LATS, MAP1$POINTS$lat)))
        if(ITF)
          {
            JEEZ[i]=1
          }
        else
          {
            
            JEEZ[i]=(-1)
          }
        
        if((i %% checkind)==0) {

          print(paste(sep=" " , "Working on stroke ", i, " of ", Kmap ))
           save(JEEZ, file=savefile)


        }
      }
    
    invisible(JEEZ)
    
    
  }

