`seeGEOmap` <-
function()
  {
    coastmap=coast2=coast3=coast4=NULL
    data(coastmap)
    
    data(coast2)
    data(coast3)
    
    GEOmap::plotGEOmap(coastmap, border='black')
    title(main="click 3 times: 1=origin, 2-3 borders")
    carolinablue = rgb(83/255, 157/255, 194/255)
    L = locator(1, type='p', col="purple")
    
    proj = GEOmap::setPROJ(2, LON0=L$x, LAT0=L$y)
    L2 = locator(2, type='p', col="purple")
    R = GEOmap::GLOB.XY(sort(L2$y) , sort(L2$x), proj)
    R = GEOmap::XY.GLOB(R$x, R$y, proj)
    RLON = R$lon
    RLAT = R$lat
    ##  par(bg=carolinablue)
    thecols=c('#52E1FF','#46CDFF','#39B1FF','#319BFF')

    majorcoastcol = "#D9D9FF"
   
    MYLIM = GEOmap::GLOB.XY(RLAT , RLON, proj)
    plot(MYLIM$x, MYLIM$y, type='n', xaxs='i', yaxs='i', asp=1, xlab='', ylab='',axes=FALSE, ann=FALSE)
    u = par('usr')

    ux = u[1:2]
    uy = u[3:4]
    
  ##   polygon(c(MYLIM$x[1], MYLIM$x[2], MYLIM$x[2], MYLIM$x[1]  ),
 ##            c(MYLIM$y[1], MYLIM$y[1], MYLIM$y[2], MYLIM$y[2])
 ##            , col=thecols[2])


    polygon(c(ux[1], ux[2], ux[2], ux[1]  ),
            c(uy[1], uy[1], uy[2], uy[2])
            , col=thecols[2])



    

    coastmapXY(coast2,  LIM=c(RLON[1], RLAT[1], RLON[2], RLAT[2]), PROJ=proj, border='black', add=TRUE)
    u = par('usr')
    limLL = GEOmap::XY.GLOB(  c(u[1], u[2]  ), c(u[3], u[4]),proj)
    coastmapXY(coast3, LIM=c(limLL$lon[1], limLL$lat[1],limLL$lon[2], limLL$lat[2] ), PROJ=proj,
               add=TRUE, border='black' )


    u = par('usr')
    
  

    XYBB = list(x=c(u[1], u[2])  , y = c(u[3],u[4]) )
    
      GEOmap::sqrTICXY(XYBB, proj, LLgrid = FALSE)

    

    invisible(list(proj=proj, LIM=limLL) )

  }

