\name{GEOinout}
\alias{GEOinout}
\title{Test for internal points in a GEOmap }
\description{
  Check whether a set of strokes in one GEOmap is
  internal to another set.  If any points of test set lie in
  a stroke of the base it is considered internal.
}
\usage{
GEOinout(MAPTEST, NTEST = 1, MAPBASE = MAPTEST, NBASE = 1, SHOWIT = FALSE)
}
\arguments{
  \item{MAPTEST}{GEOmap that is being test for stroke inclusion }
  \item{NTEST}{index of strokes to test in MAPTEST }
  \item{MAPBASE}{GEOmap base to test against }
  \item{NBASE}{index of strokes to test in MAPBASE }
  \item{SHOWIT}{ logical, whether to plot each element}
}
\details{
  Uses splancs inout function
}
\value{
  \item{INTEMP}{vector of internal strokes}
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{inout}
\examples{

\dontrun{

GEOinout(coast3, iid[1], coast2, which(coast2$STROKES$nam=="Africa"))


}

}
\keyword{misc}
