\name{LAMAZpoints}
\alias{LAMAZpoints}
\title{Lambert-Azimuthal projection }
\description{
  return Lambert-Azimuthal projection points
}
\usage{
LAMAZpoints(phicen, lamcen, worldmap, i)
}
\arguments{
  \item{phicen}{lon }
  \item{lamcen}{lat }
  \item{worldmap}{GEOmap }
  \item{i}{index of GEOmap stroke }
}

\value{
  Graphical Side Effects
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{GlobeView}
\examples{

library(GEOmap)
data(coastmap)
data(coast2)

ant1 = which(coast2$STROKES$nam=="ANTARCMAP")
phicen  =-90
lamcen  =-90
MAXR    = 100

carolinablue = rgb(83/255, 157/255, 194/255)

ant2 = which(coastmap$STROKES$nam=="ANTARCMAP")
newxy = LAMAZpoints(phicen, lamcen,coastmap, ant2 )

PER = GEOmap::GlobeView(phicen, lamcen, SEL=ant1, coast2 , 25, linecol=rgb(.2, .2, .2), mapcol='#D9D9FF', 
innercol=carolinablue , circol='purple' ,    backcol="white")

lines(newxy$x, newxy$y, col='blue')



}
\keyword{misc}
