\name{RotatePoints}
\alias{RotatePoints}
\title{Rotate points in polygon}
\description{
  Re-organize points so a different point will
  be in position 1 in a stroked polygon.
  Program tries to select the most eastern point.
}
\usage{
RotatePoints(MM, K = 180)
}
\arguments{
  \item{MM}{GEOmap with one stroke}
  \item{K}{starting longitude used to shift full trace}
}
\details{
  use K to shift longitude in case points cross large boundary
}
\value{
  \item{MM}{list x, y coordinates  shifted}

}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}
\examples{

data(coast2)
#######   extract a stroke from the GEOmap
MM = GEOmap::GEOmap.Extract( coast2 ,
SEL=which(coast2$STROKES$nam=="NewZealand_S"),  INOUT="in" )
######  re shuffle the points
ZZ = RotatePoints(MM, 0)
}
\keyword{misc}
