\name{coast2}
\alias{coast2}
\alias{coast3}
\alias{coast4}
\alias{coastmap}

\docType{data}
\title{Hi-res World Map}
\description{
  Hi-resolution geographic map of world coastlines. Selected from world2
  and polygonned.
}
\usage{data(coast2)}
\format{
  List structure:
    \describe{
  \item{STROKES}{list(nam, num, index, col, style, code, LAT1, LAT2, LON1, LON2)}
  \item{POINTS}{list(lat, lon)}
  \item{PROJ}{list(type, LAT0, LON0, LAT1, LAT2, LATS, LONS, DLAT, DLON,
    FE, FN, name)}
  }
}
\details{
  Detailed world map.  These strokes have been rectified and editted for
  content.  A few errors were fixed from world2 - e.g. antarctica and the
  philippines. Each stroke is a fillable polygon - large lakes have a
  different color.
  Codes are "C"=major coast, "c"=minor coast, "L"=major
  lake.
}
\source{
 CIA data Base
}
\seealso{world2}
\examples{
data(coast2)
## New Zealand
lonflag = coast2$POINTS$lon> 166.4904 & coast2$POINTS$lon<179.4312
latflag =  coast2$POINTS$lat>-49.72068  & coast2$POINTS$lat< -33.96452
plot(coast2$POINTS$lon[lonflag&latflag],
coast2$POINTS$lat[lonflag&latflag], type='n', xlab='lon', ylab='lat')

library(GEOmap)


z = GEOmap::GEOmap.Extract(coast2, grep("NewZealand" , coast2$STROKES$nam)
,"in")

GEOmap::plotGEOmap(z, border='black')

proj = GEOmap::setPROJ(2, LON0=mean(c(z$STROKES$LON1, z$STROKES$LON2)),
LAT0=mean(c(z$STROKES$LAT1, z$STROKES$LAT2)))

 GEOmap::plotGEOmapXY(z, PROJ=proj)

 GEOmap::plotGEOmapXY(z, PROJ=proj, border='black' )


}
\keyword{datasets}
