\name{coastmapXY}
\alias{coastmapXY}
\title{Plot a projected GEO map }
\description{
  High Level plot of GEO map

}
\usage{
coastmapXY(MAP, LIM=c(-180, -90, 180, 90), PROJ=list(),  PMAT=NULL, add=TRUE,  SEL=NULL, GRID=NULL,GRIDcol=1, MAPcol=NULL, MAPstyle=NULL, border=NA, cenlon=0, shiftlon=0, linelty=1, linelwd=1, NUMB=FALSE, ...)


}
\arguments{
\item{MAP}{Map Structure}
  \item{LIM}{Lat-Lon limits}
  \item{PROJ}{Projection list }
  \item{PMAT}{Perspective matrix conversion}
  \item{add}{logical, TRUE= add to existing plot}
  \item{SEL}{Index vector of strokes to be used in plotting,default=NULL(use all that pass other tests) }
  \item{GRID}{logical, TRUE=add grid lines}
  \item{GRIDcol}{color for grid lines}
  \item{MAPcol}{override color for maps}
  \item{MAPstyle}{override plotting style for maps}
  \item{border}{color, add border to polygons, NA=no border}
  \item{cenlon}{center longitude of plot}
  \item{shiftlon}{degrees, rotate longitude}
  \item{linelty}{Line type}
  \item{linelwd}{line width}
  \item{NUMB}{logical, number the strokes on the map}
  \item{\dots}{graphical parameters}
  
}
\details{
 coastmapXY includes projection of the data, plotGEOmap does
  not.  MAPcol and MAPstyle can be used to override the
  colors and style in the map-list.  These are applied to all the strokes.

}



\value{
  Graphical Side Effects
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{coastmapXY}
\examples{
data(coast2)
ig = grep("NewF", coast2$STROKES$nam , ignore.case =TRUE)
z = GEOmap::GEOmap.Extract(coast2, ig ,"in")
RLON=range(c(z$STROKES$LON1, z$STROKES$LON2))
RLAT =range(c(z$STROKES$LAT1, z$STROKES$LAT2))

proj = GEOmap::setPROJ(2, LON0=mean(RLON), LAT0=mean(RLAT))
LIMXY = GEOmap::GLOB.XY(RLAT, RLON, proj)

L = GEOmap::XY.GLOB(LIMXY$x, LIMXY$y, proj)

coastmapXY(coast2, LIM=c(L$lon[1], L$lat[1], L$lon[2], L$lat[2]), add=FALSE, PROJ=proj, border='black' )


}
\keyword{misc}
