\name{eqs}
\alias{eqs}
\docType{data}
\title{Global Earthquake Data 1900-1999}
\description{
  Relocated historic earthquake events from the Engdahl Data base
}

\usage{data(eqs)}
\format{
  List:
    \describe{
\item{yr}{Year}
\item{hr}{Hour}
\item{mi}{minute}
\item{sec}{Sec}
\item{jd}{Julian Day}
\item{lat}{Latitude}
\item{lon}{Longitude}
\item{z}{Depth, km below sea level}
\item{mag}{Magnitude}
}
}

\source{http://earthquake.usgs.gov/research/data/centennial.php
}

\references{
  Engdahl, E.R., and A. Villasenor, Global Seismicity: 1900-1999,
  in W.H.K. Lee, H. Kanamori, P.C. Jennings, and C. Kisslinger (editors),
  International Handbook of Earthquake and Engineering Seismology,
  Part A, Chapter 41, pp. 665-690, Academic Press, 2002.

Engdahl, E.R., R. van der Hilst, and R. Buland, Global teleseismic
  earthquake relocation with improved travel times and procedures for
  depth determination, Bull. Seism. Soc. Am. 88, 722-743, 1998.
  }
\examples{
data(eqs)

plot(eqs$lon, eqs$lat, pch=".", col='red')


}
\keyword{datasets}
