\name{fastGEOmap}
\alias{fastGEOmap}
\title{Plot a GEOmap quickly}
\description{
  Plot a GEOmap quickly by taking some shortcuts.
}
\usage{
fastGEOmap(MAP, OUT)
}
\arguments{
  \item{MAP}{GEOmap list}
  \item{OUT}{list of LIM and proj}
}
\details{
  This program uses a map usually extracted from the
  larger data bases (using myGEOmap) and assembled.
  Sometimes this is not so fast, depending on the size of the extracted
  map.
  But it should be faster than starting with the full data bases.
}
\value{
  \item{list}{projection list, LIM=lat-lon limits}
}
\author{Jonathan M. Lees<jonathan.lees@unc.edu>}
\seealso{seeGEOmap, ReseeGEOmap, myGEOmap, SELGEOmap}
\examples{
\dontrun{
proj = GEOmap::setPROJ(type = 2, LAT0 =47.8334881040238 , LON0 =238.118472492573 )

MOUT = list(proj=proj ,LIM=list(lat=c(45.125581941451,51.4063149547121),
                  lon=c(230.934455221914,243.302323059975) ))
		  OUT  = ReseeGEOmap(MOUT)
MAP =  myGEOmap( MOUT)
fastGEOmap(MAP, MOUT)
}


}
\keyword{misc}
