\name{indexGEOpoints}
\alias{indexGEOpoints}
\title{Associate Points with GEOmap strokes}
\description{
  Associate Points with the respective index of GEOmap strokes
}
\usage{
indexGEOpoints(MAP)
}
\arguments{
  \item{MAP}{GEOmap list}
}

\value{
  \item{vector}{ index of strokes in STROKES list of MAP}
 
}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\examples{

proj = GEOmap::setPROJ(type = 2, LAT0 =47.8334881040238 , LON0 =238.118472492573 )

MOUT = list(proj=proj ,
LIM=list(lat=c(45.125581941451,51.4063149547121),lon=c(230.934455221914,243.302323059975) )  )

 data(coast2)

myinout = inrectGEO(coast2$POINTS$lat, coast2$POINTS$lon, MOUT$LIM,  MOUT$proj)
myind = indexGEOpoints(coast2 )

istrokes = unique(myind[myinout])
nams = coast2$STROKES$nam[istrokes]
print( nams )

}
\keyword{misc}
