\name{inrectGEO}
\alias{inrectGEO}
\title{inrectGEO}
\description{
  Test for lat-lon point inclusion in a rectangle defined
  by two points in lat-lon (lower left, upper right)
}
\usage{
inrectGEO(lat1, lon1, georect, proj)
}
\arguments{
  \item{lat1}{vector of latitudes }
  \item{lon1}{vector of longitudes }
  \item{georect}{rectangle list (lon, lat) giving lower left and upper
    right points }
  \item{proj}{projection list }
}
\details{
  The points are project first and tested on a flattened x,y grid.
}
\value{
  \item{vector}{logical, FALSE=outside rectangle}

}

\author{Jonathan M. Lees<jonathan.lees@unc.edu>}

\seealso{SELGEOmap}
\examples{
###############  set up a projection
data(coast2)

proj = GEOmap::setPROJ(type = 2, LAT0 =47.8334881040238 , LON0 =238.118472492573 )

MOUT = list(proj=proj ,
LIM=list(lat=c(45.125581941451,51.4063149547121),
lon=c(230.934455221914,243.302323059975))  )


myinout = inrectGEO(coast2$STROKES$LAT1, coast2$STROKES$LON1, MOUT$LIM,  MOUT$proj)

which(myinout)

nams = coast2$STROKES$nam[which(myinout)]

 print(nams)

myinout = inrectGEO(coast2$POINTS$lat, coast2$POINTS$lon, MOUT$LIM,  MOUT$proj)

myind = indexGEOpoints(coast2 )

istrokes = unique(myind[myinout])

nams = coast2$STROKES$nam[istrokes]
print(nams)

}
\keyword{misc}
