\name{isochron}
\alias{isochron}
\docType{data}
\title{Ocean isochrons}
\description{
  Digital isochrons of the world's ocean floor
}
\usage{data(isochron)}
\format{
  List structure:
   \describe{
  \item{STROKES}{list(nam, num, index, col, style, code, LAT1, LAT2, LON1, LON2, age
)}
  \item{POINTS}{list(lat, lon)}
  \item{PROJ}{list(type, LAT0, LON0, LAT1, LAT2, LATS, LONS, DLAT, DLON, FE, FN
    , name)}
  }

}

\details{
 Isochrons are lines
}
\source{
 http://gdcinfo.agg.nrcan.gc.ca/app/jgr\_paper\_e.html
}
\references{

R. Dietmar Mueller, Walter R. Roest, Jean-Yves Royer,
Lisa M. Gahagan, and John G. Sclater,
Digital isochrons of the world's ocean floor
Journal of Geophysical Research, vol.102, no.B2, pp.3211-3214, 10 Feb
1997


}
\examples{
data(isochron)
#
library(geomapdata)

library(GEOmap)
data(worldmap)

GEOmap::plotGEOmap(worldmap)

GEOmap::plotGEOmap(isochron, add=TRUE)




}
\keyword{datasets}
