ClockCircle<-function( fudge = .05,   cex=1, tcol='black', 
                      border = 'black' ,blwd=1,
                      cross=NA, clwd=1,
                      cseg='black', lseg=1,
                      SRT=TRUE, HOUR=0,
                      MIN=0, font=1, add=FALSE
                      )
{
    TOL = 1e-15
    TEE  =1:12
    TEE1 = c(1:5, 7:11)
    ang = 90 - seq(from=30, to=360, by=30)
    
   
    ndiv = 72   
    angs = c(-pi, pi)
    phi = seq(angs[1], angs[2], by = (angs[2] - angs[1])/ndiv)
    xQ = cos(phi)
    yQ = sin(phi)

    #########  plotting here
    if(!add) plot(xQ, yQ, type = "n", ann = FALSE, axes = FALSE, asp = TRUE)
    points(0,0, pch=3)
    lines(xQ, yQ, col = border, lwd=blwd)

    if(MIN>0)
    {
        ndiv = 360/6
        
        angs = c(-pi, pi)
        phi = seq(from=angs[1],to= angs[2], by = (angs[2] - angs[1])/ndiv)

        rad = 1-MIN
        
        xM = cos(phi)
        yM = sin(phi)
        
        segments( rad*xM, rad*yM, xM, yM, col=cseg, lwd=lseg )

        }

    if(!is.na(cross) )
    {
        segments(0, -1, 0, 1, col=cross, lwd=clwd)
        segments(-1, 0, 1, 0, col=cross, lwd=clwd)
    }
    
 #   text(0, 1, labels='12',cex=1.2,  pos=3, xpd=TRUE )
 #   text(0, -1, labels='6',cex=1.2, pos=1, xpd=TRUE )

    tee = TEE
    angs = ang
    alpha = angs*pi/180
   
    x = cos(alpha)
    y = sin(alpha)
                                        #points(x,y)
    if(!is.na(cseg) )
    {
    segments(HOUR*x, HOUR*y, x,y, col=cseg, lwd=lseg )
    }
    
    
    for(i in 1:length(x) )
    {
        if(abs(x[i])<TOL) x[i] = 0
        if(abs(y[i])<TOL) y[i] = 0
        
        ## print(paste(i,TEE[i],  ang[i], x[i],y[i]) )
        asrt =  RotateLabel(c(0,0), c(x[i],y[i]), fudge=fudge )

        if(!SRT) asrt[3]=0
       # points(x[i],y[i], pch='.', cex=2)
        text(asrt[1],asrt[2], labels=tee[i], srt = asrt[3],
             xpd=TRUE ,col=tcol,  cex=cex, font=font  )
    }
    
}

