CurlyBracket<-function(P, offset=0.1, pct = 0.1,  ...)
    {
##    Goes from the first point to the second
        LEN = sqrt( diff(P$x)^2 + diff(P$y)^2 )
        theta = atan2(diff(P$y), diff(P$x))
        Pcen = list( x= mean(P$x), y=mean(P$y) )
        Vdir = list( x = (P$x[2] - P$x[1])/LEN , y = (P$y[2] - P$y[1])/LEN)

        Vperp = list(x = -Vdir$y, y=Vdir$x)
        
        
        POFF = list( x= Pcen$x+offset*Vperp$x  , y = Pcen$y+offset*Vperp$y )
        
        halfLEN = LEN/2
        
        
        ZED =  BRAKIT(xleft=-halfLEN, delbrak = -halfLEN+halfLEN*pct, ytop = halfLEN*pct/2, tipY =halfLEN*pct  , xright = -halfLEN*pct  )
        J = cbind(ZED$x, ZED$y) %*% matrix(c(cos(theta), -sin(theta), sin(theta), cos(theta) ) , ncol=2)
        BRAX = list(x=POFF$x+ J[,1]  , y=POFF$y+J[, 2]  )
        
        lines(BRAX$x  , BRAX$y, ... )
        elen = length(BRAX$x)/2
        BRAX$angle = theta*180/pi
        BRAX$tip = list(x=BRAX$x[elen], y=BRAX$y[elen] )
        return(BRAX) 
    }
