LabelAngle <-
function(V1, V2, r=1, snake=NULL, pos=3 )
    {
#### V1 and V2 are vectors, r is the radius
### the Vi should include 2 points
####  the arc goes from V1 to V2 with origin at V1[1]


        ### vecs should in format x1, y1, x2, y2

        if(is.list(V1) )
            {
                V1 = c(V1$x[1], V1$y[1], V1$x[2], V1$y[2] ) 
                
            }
        if(is.list(V2) )
            {
                V2 = c(V2$x[1], V2$y[1], V2$x[2], V2$y[2] ) 
                
            }

        
        d1 = c( V1[3] - V1[1], V1[4] - V1[2] )
        d2 = c( V2[3] - V2[1], V2[4] - V2[2] )

        ### normalized directions
        n1 =  d1/sqrt(d1[1]^2 + d1[2]^2)
        
        n2 = d2/sqrt(d2[1]^2 + d2[2]^2)

        ang1 = atan2(n1[2], n1[1] )*180/pi
        
        ang2 = acos( sum(n1 * n2) )*180/pi

        ####  get cross product direction, polarity sense
        xp.k = d1[1]*d2[2] - d1[2]*d2[2]
        idir  = sign(xp.k) 
        ang3 = ang1 + idir*ang2

        ##########
        
        ark1 = GEOmap::darc(rad = r, ang1 = ang1, ang2 = ang3, V1[1], V1[2]  , n = 1)
        lines(ark1)
 
        if(!is.null(snake) )
            {
                sp1 =  GEOmap::getspline(snake$x, snake$y, 10 )
                nsp  = length(sp1$x)

                lines(sp1)
                
                k = formatC(ang2, width=3)
                text(sp1$x[nsp], sp1$y[nsp], bquote(.(k)^o ) , pos=pos)
                arrows(sp1$x[2], sp1$y[2], sp1$x[1], sp1$y[1], length=0.05) 
            }

        return(ark1) 
        
    }
