VecAngle <-
function(V1, V2, r=1, snake=NULL, pos=3, laboutside=TRUE, lty=1, lwd=1 , col='black', sig.digits=1  )
    {
#### calculate and lable the angle between two vectors
        
#######   look in /Users/lees/Vignettes/Drafting/CODE

        
#### V1 and V2 are vectors, r is the radius
### the Vi should include 2 points
####  the arc goes from V1 to V2 with origin at V1[1]


        ### vecs should in format x1, y1, x2, y2

        if(is.list(V1) )
            {
                V1 = c(V1$x[1], V1$y[1], V1$x[2], V1$y[2] ) 
                
            }
        if(is.list(V2) )
            {
                V2 = c(V2$x[1], V2$y[1], V2$x[2], V2$y[2] ) 
                
            }

        
        d1 = c( V1[3] - V1[1], V1[4] - V1[2] )
        d2 = c( V2[3] - V2[1], V2[4] - V2[2] )

        d1.norm = sqrt(d1[1]^2 + d1[2]^2)
        d2.norm = sqrt(d2[1]^2 + d2[2]^2)
        
### normalized directions

        if(d1.norm==0 | d2.norm==0)
            {
                warning('ERROR: vectors are not correct')
                return(NULL)
            }
        
        n1 =  d1/sqrt(d1[1]^2 + d1[2]^2)
        
        n2 = d2/sqrt(d2[1]^2 + d2[2]^2)

       
        
        ang1 = atan2(n1[2], n1[1] )*180/pi
        
        ang2 = acos( sum(n1 * n2) )*180/pi

        if(ang2==0)
            {
           warning('ERROR: vectors are co-linear')
                return(NULL)
            }
        
        ang3 = ang1 + ang2

        ##########
        
        ark1 = GEOmap::darc(rad = r, ang1 = ang1, ang2 = ang3, V1[1], V1[2]  , n = 1)
        lines(ark1)


        nark = length(ark1$x)
        nark.cen = round(nark/2)


        ############  set up the character that needs to be plotted

        if(sig.digits>=0)
            {
                gchar = round(ang2, sig.digits)
            }
        else
            {
                gchar = ang2
            }
        

        kchar = formatC(gchar)
############ \u02DA


     ######   U.degree = "\u00b0"
############      intToUtf8(176)

        if(!is.null(snake) )
            {
                if(length(snake)==1 )
                    {
                        ##  put the degrees in the center
###  find point just beyond the arc
                        hx = ark1$x[nark.cen]
                        hy = ark1$y[nark.cen]
                       
                        jangle = atan2(V1[2]-hy, V1[1]-hx)

                        
                        text(hx , hy , paste0(kchar,intToUtf8(176)) , pos=pos)

                    }

                if(length(snake$x)>1)
                    {
                        ####  draw a spliny to the location and an arrow
                        sp1 =  GEOmap::getspline(snake$x, snake$y, 10 )
                        nsp  = length(sp1$x)

                        lines(sp1)
                        
                        k = formatC(ang2, width=3)
                        text(sp1$x[nsp], sp1$y[nsp], labels=paste0(gchar,intToUtf8(176)), pos=pos)
                        arrows(sp1$x[2], sp1$y[2], sp1$x[1], sp1$y[1], length=0.05)
                    }
            }



        

        return(ark1) 
        
    }
