draw.humanstick <-
function(x,  y, siz=siz, col="black", border="black", standing=FALSE)
    {

        
        if(missing(col)) { col=rep(1,length=length(x)) }
        if(missing(siz)) { siz=rep(.2,length=length(x)) }
        if(missing(border)) { border="black"}

        if(length(siz)<length(x)) { siz=rep(siz,length=length(x)) }
        if(length(col)<length(x)) { col=rep(col,length=length(x)) }
        if(length(border)<length(x)) { border=rep(border[1],length=length(x)) }

        up = par("usr")
        ui = par("pin")

        ratx = (up[2]-up[1])/ui[1]
        raty=  (up[4]-up[3])/ui[2]

### there are nine strokes

###
        g1 = RPMG::circle(10)
        ##    plot(c(-1,1), c(-1,1), asp=1, type='n')
        r1 = 0.25
        r2 = 0.35

        
        lims = list(x=c( 0.5085514, 0.1808321),
            y=c(-0.82310953, -0.09753355) )
        
        if(standing)
            {
                standing.shift = abs(lims$y[1])
            }
        else
            {
                standing.shift = 0
            } 
        eye.rad = 0.035
        e.left = list(x= 0.0934798, y=0.5595919)
        
        head = list(x=0+r1*g1$x, y=0.5+r1*g1$y)
        trunc = list(x=c(0,0), y=c(0.5-r1, -r2) )
        eye.left=list( x=e.left$x+eye.rad*g1$x, y=e.left$y+eye.rad*g1$y )
        eye.right=list( x=-e.left$x+eye.rad*g1$x, y=eye.left$y )
        smile =GEOmap::darc( rad=0.5595919-.4,ang1=-60  , ang2=-120 ,  x1=0,y1= 0.5595919, n=1)
#######  to shift from heart to standing
        left.leg = list( x=c(0, lims$x[1]) , y=c(-r2,  lims$y[1])  )
        right.leg = list( x=c(0, -lims$x[1]) , y=c(-r2,  lims$y[1])  )
        left.arm = list(x=c(0,0.5085514), y=c(0,0.1808321))
        right.arm = list(x=c(0,-left.arm$x[2]), y=left.arm$y)

        stick.icon= list(
            head = head,
            trunc = trunc,
            eye.left=eye.left,
            eye.right=eye.right,
            smile =smile,
            left.leg =left.leg ,
            right.leg =right.leg,
            left.arm = left.arm,
            right.arm = right.arm
        )

        
        ##  plot(c(-1,1), c(-1,1), asp=1, type='n')
        ##  grid()
        for(i in 1:length(x))
            {
                x0 = x[i]       
                y0 = y[i]
                
                usizx = siz[i]*ratx
                usizy = siz[i]*raty

                y0=y0+usizy*standing.shift
                
                polygon(x0+usizx*head$x, y0+usizy*head$y, border=border)
                lines(x0+usizx*trunc$x, y0+usizy*trunc$y, col=border)
                
                segments(x0+usizx*left.leg$x[1], y0+usizy*left.leg$y[1], x0+usizx*left.leg$x[2], y0+usizy*left.leg$y[2], col=border )
                segments(x0+usizx*right.leg$x[1], y0+usizy*right.leg$y[1], x0+usizx*right.leg$x[2], y0+usizy*right.leg$y[2] , col=border)

                segments(x0+usizx*left.arm$x[1], y0+usizy*left.arm$y[1], x0+usizx*left.arm$x[2], y0+usizy*left.arm$y[2] , col=border)
                segments(x0+usizx*right.arm$x[1], y0+usizy*right.arm$y[1], x0+usizx*right.arm$x[2], y0+usizy*right.arm$y[2] , col=border)

                polygon(x=x0+usizx*eye.left$x, y=y0+usizy*eye.left$y , border=border)
                polygon(x=x0+usizx*eye.right$x, y=y0+usizy*eye.right$y , border=border)

                lines(x0+usizx*smile$x, y0+usizy*smile$y, col=border)
                
            }



    }
