rotrect <-
function(L, PLOT=TRUE, ...)
  {
    if(missing(L))
      {
        L = locator(n=3, type="p" , pch=3)
      }
    if(missing(PLOT)) { PLOT=TRUE }

    V1x = L$x[2]-L$x[1]
    V1y = L$y[2]-L$y[1]

    V2x = L$x[3]-L$x[1]
    V2y = L$y[3]-L$y[1]


    d1 = sqrt(V1x^2+V1y^2)
    d2 = sqrt(V2x^2+V2y^2)

    V2 = c(V2x, V2y)/d2
    V1 = c(V1x, V1y)/d1
    cosalph = (V1[1]*V2[1]+V1[2]*V2[2])


    if(d1>d2)
      {
        ## project onto d2
        p3x = L$x[1]+ cosalph*d1*V2[1]
        p3y = L$y[1]+ cosalph*d1*V2[2]
###points(p3x, p3y)

        p4x = L$x[1]+ (L$x[2]-p3x)
        p4y = L$y[1]+ (L$y[2]-p3y)

        NX = c(L$x[1], p3x, L$x[2], p4x)
        NY = c(L$y[1], p3y, L$y[2], p4y)
      }
    else
      {
        p3x = L$x[1]+ cosalph*d2*V1[1]
        p3y = L$y[1]+ cosalph*d2*V1[2]
###points(p3x, p3y)

        p4x = L$x[1]+ (L$x[3]-p3x)
        p4y = L$y[1]+ (L$y[3]-p3y)

        NX = c(L$x[1], p3x, L$x[3], p4x)
        NY = c(L$y[1], p3y, L$y[3], p4y)

      }
    if(PLOT) polygon(NX, NY, ...)
    return(list(x=NX, y=NY))

  }
