\name{BRAKIT}
\alias{BRAKIT}
\title{Basic Curly Bracket
}
\description{Create a curly bracket with given graphical parameters.
}
\usage{
BRAKIT(N1 = 20, xleft = -1, delbrak = -0.8, ytop = 0.25, tipY = 0.3124366, xright = -0.1)
}
\arguments{
  \item{N1}{integer number of points in the curly parts
}
  \item{xleft}{float, half length of bracket
}
  \item{delbrak}{x-distance from end to top of sinusoid
}
  \item{ytop}{height of the main body (flat part) of the bracket
}
  \item{tipY}{ height of the tip
}
  \item{xright}{x-distance from center to start of inner sinusoid
}
}
\details{
  Each end has N1 points in the sinusoids and the segment between is
  flat. The function returns a curly bracket oriented on the x-axis:
  this should be rotated and moved to desired location in plot.
}
\value{
  \item{x}{x-coordinates
  }
  \item{y}{y-coordinates
  }
 \item{delbrak}{x-distance from end to top of sinusoid
}
  \item{ytop}{height of the main body (flat part) of the bracket
}
  \item{tipY}{ height of the tip
}
  \item{xright}{x-distance from center to start of inner sinusoid
}

}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  The function is pretty crude.  May need some adjustments.
}


\seealso{CurlyBracket, LabelAngle
}
\examples{

 ZED =  BRAKIT( )

    plot(c(-1, 1),c(-1, 1), asp=1, type='n' )
    grid()
    lines(ZED)
    arrows(-1,-0.1,  ZED$delbrak,  -0.1, length=.1) 
    text( ZED$delbrak,  -0.1 ,  labels='delbrak', pos=4 )
   KLX = c( -0.94456314, -0.13477745,  0.05825286)
   KLY = c(  0.3815945, 0.3585419, 0.4184787)
    

    arrows(KLX[1], KLY[1], ZED$delbrak, ZED$ytop, length=.1)
    text(KLX[1], KLY[1], labels='(delbrak, ytop)', pos=3)
    
    arrows(KLX[2], KLY[2], ZED$xright, ZED$ytop, length=.1)
    text(KLX[2], KLY[2], labels='(xright, ytop)', pos=3) 
    
   arrows(KLX[3], KLY[3], 0, ZED$tipY, length=.1)
    text(KLX[3], KLY[3], labels='(0, tipY)', pos=4) 


}
\keyword{misc}
