\name{ClockCircle}
\alias{ClockCircle}
\title{Plot Image of a clock.
}
\description{
  Plot image of a clock with several options for
  labels and tick-marks.
}
\usage{
ClockCircle(fudge = 0.05, cex = 1, tcol = "black", border = "black", blwd = 1, cross = NA, clwd = 1, cseg = "black", lseg = 1, SRT = TRUE, HOUR = 0, MIN = 0, font = 1, add = FALSE)
}
\arguments{
  \item{fudge}{Amount to shift the text away from the plotting
    point. Units are units of radii (1)
}
  \item{cex}{Character  expansion for text
}
  \item{tcol}{Color for text
}
  \item{border}{Color for border
}
  \item{blwd}{Line width for border
}
  \item{cross}{Color for Vertical/Horizontal Cross hairs
}
  \item{clwd}{Line width for Vertical/Horizontal Cross hairs
}
  \item{cseg}{Color for radial segments
}
  \item{lseg}{Linewidth for radial segments
}
  \item{SRT}{Logical, whether to rotate text
}
  \item{HOUR}{Hour ticks
}
  \item{MIN}{Minute ticks
}
  \item{font}{Font specified (1,2)
}
  \item{add}{Whether to issue new plot (FALSE) or add to existing plot (TRUE)
}
}
\details{
  Coordinate system is North-Clockwise.
  Rotation of text is calculated by function RotateLabel.
  The fudge value is relative to a default radius of 1.
}
\value{Graphical Side effects.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{RotateLabel, Compass
}
\examples{

    ClockCircle(fudge = .05,   cex=1.5, tcol='black', 
                      border = 'black' ,blwd=1,
                      cross=NA , clwd=1,
                cseg='black' , lseg=1, HOUR=.9,  MIN=0.06 )

 ClockCircle(fudge = .05,   cex=1.5, tcol='black', 
                      border = 'black' ,blwd=1,
                      cross=NA , clwd=1,
                cseg='black' , lseg=1, HOUR=.9,  MIN=0.06, SRT=FALSE )


  ClockCircle(fudge = -.15,   cex=1.5, tcol='black', 
                      border = 'black' ,blwd=1,
                      cross=NA , clwd=1,
                cseg='black' , lseg=1, HOUR=.9,  MIN=0.06, SRT=FALSE, font=2 )




}
\keyword{misc}
