\name{Compass}
\alias{Compass}
\title{Plot Simple Compass.
}
\description{
  Plot Compass with text string rotated appropriatly.
}
\usage{
Compass(fudge = 0.05, cex = 1, tcol = "black", border = "black", blwd = 1, cross = NA, clwd = 1, cseg = "black", lseg = 1, SRT = TRUE, R1 = 0, R2 = 1, font = 1, add = FALSE)
}
\arguments{
  \item{fudge}{Amount to shift the text away from the plotting
    point. Units are units of radii (1)
}
  \item{cex}{Character  expansion for text
}
  \item{tcol}{Color for text
}
  \item{border}{Color for border
}
  \item{blwd}{Line width for border
}
  \item{cross}{Color for Vertical/Horizontal Cross hairs
}
  \item{clwd}{Line width for Vertical/Horizontal Cross hairs
}
  \item{cseg}{Color for radial segments
}
  \item{lseg}{Linewidth for radial segments
}
  \item{SRT}{Logical, whether to rotate text
}
  \item{R1}{Radial distance to start ticks, default 0
}
  \item{R2}{Radial distance to end ticks, default 1
}
  \item{font}{Font specified (1,2)
}
  \item{add}{Whether to issue new plot (default, FALSE) or add to existing plot (TRUE)
}
}
\details{
  Coordinate system is North-Clockwise.
  Designed to make a plot that can be used to show directions of azimuth and
  backazimuth for rotating seismic data.
}
\value{Graphical Side effects.
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{RotateLabel, ClockCircle
}
\examples{
    Compass(fudge = .05,   cex=1, tcol='black', 
                      border = 'black' ,blwd=1,
                      cross=NA, clwd=1,
                      cseg='black', lseg=1,
                      SRT=TRUE, R1=0.95,
            R2=1, font=1, add=FALSE )


     Compass(fudge = -.05,   cex=1.1, tcol='blue', 
                      border = 'black' ,blwd=1,
                      cross=NA, clwd=1,
                      cseg=grey(0.8), lseg=1.5,
                      SRT=TRUE, R1=0.15,
            R2=1, font=2, add=FALSE )

Compass(fudge = .05,   cex=1.1, tcol='blue', 
                      border = grey(0.8)  ,blwd=1,
                      cross=grey(0.8), clwd=1,
                      cseg=grey(0.8), lseg=1.5,
                      SRT=TRUE, R1=0.95,
            R2=1, font=2, add=FALSE )



}
\keyword{misc}
