\name{CurlyBracket}
\alias{CurlyBracket}
\title{Draw Curly Bracket 
}
\description{
  Draw  curly bracket on an existing plot to indicate
  and label items in the plot.
}
\usage{
CurlyBracket(P, offset = 0.1, pct = 0.1, ...)
}
\arguments{
  \item{P}{Two end-points in an x-y list, list(x=c(x1,x2), y=c(y1, y2))
}
  \item{offset}{distance offset by the curly bracket
}
  \item{pct}{Percent curly part takes up relative to the half length of
    the brackets.
}
  \item{\dots}{optional graphical parameters passed on to plotting,
    e.g. col, lwd, lty, etc.
}
}
\details{The code is pretty generic but may need some tweaking.
  the orientation is from the first point to the second -
  the order determines the orientation of the brackets.
  The tip of the bracket is useful for plotting labels and text.
  
}
\value{
  \item{x}{x-coordinates}
  \item{y}{y-coordinates}
  \item{angle}{rotation angle in degrees}
  \item{tip}{x,y coordinates of the tip of the bracket}
  
 
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{ Orientation may be confusing.
  
}


\seealso{BRAKIT, LabelAngle
}
\examples{


plot(c(0, 11), c(2, 9) ,   type='n', axes=FALSE, ann=FALSE )
# grid()

P2=list()
P2$x=c(1.46188390843,4.76903632243)
P2$y=c(6.23741693087,2.96428041295)

H = CurlyBracket(P2, offset=0.1, col='blue' , lwd=2)
text(H$tip$x , H$tip$y, 'Second Difference', pos=4, font=2 , cex=1.5, col='blue'   )
   
#### or:

P2=list()
P2$x=c(1.46188390843,4.76903632243)+4
P2$y=c(6.23741693087,2.96428041295)+3

H = CurlyBracket(P2, offset=0.1, col='blue' , lwd=2)

text(H$tip$x , H$tip$y, 'Rotated Text', pos=3, font=2 , cex=1.5,
col='blue', srt=H$angle    )
   




}
\keyword{misc}
