\name{LabelAngle}
\alias{LabelAngle}
\title{Label Angle
}
\description{Label an Angle on a plot
}
\usage{
LabelAngle(V1, V2, r = 1, snake = NULL, pos = 3)
}
\arguments{
  \item{V1}{vector as:  (x1, y1, x2, y2)
}
  \item{V2}{vector as:  (x1, y1, x2, y2)
}
  \item{r}{ radius
}
  \item{snake}{ snake points, if provided. see details
}
  \item{pos}{position: 1,2,3,4
}
}
\details{
An angle is labeled between two vectors,
and the label is snaked if 3 or more points are provided to
move the label off to the side.
}
\value{list of the arc drawn
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{SnakeLabel, GEOmap::getspline
}
\examples{

plot(c(0, 50), c(0, 10) , type='n', asp=1  )
P1 = list(x=10, y=4)
P2 = list(x=40, y=6)
P3 = list(x=20, y=15)

 points(P1)
points(P2)
points(P3)
text(P1, labels='P1', pos=3)
text(P2, labels='P2', pos=3)
text(P3,labels='P3', pos=3)
arrows(P1$x, P1$y, P2$x, P2$y, length=0.1) 
arrows(P1$x, P1$y, P3$x, P3$y, length=0.1) 

V1 = c( P1$x[1], P1$y[1], P3$x[1], P3$y[1] ) 
V2 = c( P1$x[1], P1$y[1] , P2$x[1], P2$y[1]   )

LabelAngle(V1, V2, r=10, snake=NULL, pos=3 )



}
\keyword{misc}
