\name{PointAngle}
\alias{PointAngle}
\title{Label Angle at a Point
}
\description{Label and angle at a point.
}
\usage{
PointAngle(x = 0, y = 0, ang1 = ang1, ang2 = ang2, rad = 1, labels = expression(alpha), adj = c(1, 1))
}
\arguments{
  \item{x}{x-coordinate
}
  \item{y}{y-coordinate
}
  \item{ang1}{starting angle
}
  \item{ang2}{ending angle
}
  \item{rad}{radius
}
  \item{labels}{label
}
  \item{adj}{adj vector
}
}
\details{
Plots an angle arc, from the vertex (x,y) with a specified radius. 
}
\value{graphical side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}

\seealso{LabelAngle
}
\examples{

P1 = c(2,2)
P2 = c(10,4)
P3 = c(6,8)

ang1 = 40   ## degrees
P4 = pvec(P1, ang1*pi/180, 5)

a1  = angBAC(P4, P1, P2)
a2  = angBAC(P2, P1, c(P2[1], P1[2] )  )

x1 = c(0, 10)
y1 = c(0, 10)

plot(range(x1), range(y1), asp=1, xlab='m', type='n' , ylab='m' )

points(P1[1], P1[2], pch=10)
points(P2[1], P2[2], pch=10)
text(P1[1], P1[2], labels="P1", pos=1)
text(P2[1], P2[2], labels="P2", pos=1)

points(P4[1], P4[2], pch=6)
segments(P1[1], P1[2], P4[1], P4[2], col='blue', pch=2)
segments(P1[1], P1[2], P2[1], P2[2], col='purple', pch=2)



PointAngle(x=P1[1],y=P1[2], ang1 = ang1, ang2 = a2*180/pi, rad=6, labels = expression(alpha), adj = c(0,0)  )


}
\keyword{misc}
