\name{RotateLabel}
\alias{RotateLabel}
\title{Rotate text at end of vector.
}
\description{
  Calculate position and rotation of text string
  at end of vector so that text is rotated and
  shifted for a graphical clarity.
}
\usage{
RotateLabel(P1, P2, fudge = 0.1)
}
\arguments{
  \item{P1}{Point (2-vector)
  }
    \item{P2}{Point (2-vector)
}
  \item{fudge}{Amount to move past P2
}
}
\details{Determines point and rotation angle for plotting strings at the
  ends of vectors. 
}
\value{vector: c(x,y,angle)
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  Angle rotations are detwemined by quadrant.
}


\seealso{LabelLine
}
\examples{

set.seed(12)

EX = cbind(runif(10, 0, 10), runif(10, 0, 10))
EY = cbind(runif(10, 0, 10), runif(10, 0, 10))


  plot(c(0,10) , c(0,10) , asp=1, type='n' )
for(i in 1:10 )
{

v1 = list(x=EX[i,] , y=EY[i, ] )
        
arrows(v1$x[1], v1$y[1], v1$x[2], v1$y[2])
s = RotateLabel(c(v1$x[1], v1$y[1]), c(v1$x[2], v1$y[2])   , fudge=0.1)
    text(s[1], s[2], labels='test', srt=s[3])

   # locator(1)
}





}
\keyword{misc}
