\name{SnakeLabel}
\alias{SnakeLabel}
\title{Snake label 
}
\description{Snake line to a label on the figure.
}
\usage{
SnakeLabel(A='', snake, n = 10, arrowlen = 0.05, pos=3)
}
\arguments{
  \item{A}{text label
}
  \item{snake}{set of (at least 3) points along which a spline is drawn.
}
  \item{n}{number of points per leg of spline.
}
  \item{arrowlen}{length of arrow head placed at start point.
}
\item{pos}{Position to plot text relative to end point}
}
\details{Used when the labels are complicated.
A spline line is interpolated along the ponts (at least 3)
where the label is placed.
Label is places att he end of the spline line.
}
\value{graphical side effects
}

\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}


\seealso{GEOmap::getspline, arrows, lines 
}
\examples{

plot(c(0, 50), c(0, 10) , type='n', asp=1  )

P1 = list(x=10, y=4)

P2 = list(x=40, y=6)
P3 = list(x=20, y=15)


 points(P1)
points(P2)
points(P3)
text(P1, labels='P1', pos=3)
text(P2, labels='P2', pos=3)
text(P3,labels='P3', pos=3)
segments(P1$x, P1$y, P2$x, P2$y) 
segments(P1$x, P1$y, P3$x, P3$y) 


g1 = gangle(P3, P1, P2)
g1.a = round(g1$ang.deg )

sn1=list()
sn1$x=c(34.0730141186,17.8838530880,14.1871331084)
sn1$y=c( 8.81325832165, 7.59537417393,-3.57457252602)

###  normally:
##  sn1 = locator(3)


SnakeLabel(A =  bquote(.(g1.a)*degree ) , sn1, n=10 )


}
\keyword{misc}
